/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedControllerService;
import org.apache.nifi.registry.flow.VersionedFunnel;
import org.apache.nifi.registry.flow.VersionedLabel;
import org.apache.nifi.registry.flow.VersionedPort;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.registry.flow.VersionedPropertyDescriptor;
import org.apache.nifi.registry.flow.VersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowComparator;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardFlowComparison;
import org.apache.nifi.registry.flow.diff.StandardFlowDifference;

public class StandardFlowComparator
implements FlowComparator {
    private final ComparableDataFlow flowA;
    private final ComparableDataFlow flowB;
    private final Set<String> externallyAccessibleServiceIds;
    private final DifferenceDescriptor differenceDescriptor;

    public StandardFlowComparator(ComparableDataFlow flowA, ComparableDataFlow flowB, Set<String> externallyAccessibleServiceIds, DifferenceDescriptor differenceDescriptor) {
        this.flowA = flowA;
        this.flowB = flowB;
        this.externallyAccessibleServiceIds = externallyAccessibleServiceIds;
        this.differenceDescriptor = differenceDescriptor;
    }

    @Override
    public FlowComparison compare() {
        VersionedProcessGroup groupA = this.flowA.getContents();
        VersionedProcessGroup groupB = this.flowB.getContents();
        Set<FlowDifference> differences = this.compare(groupA, groupB);
        return new StandardFlowComparison(this.flowA, this.flowB, differences);
    }

    private Set<FlowDifference> compare(VersionedProcessGroup groupA, VersionedProcessGroup groupB) {
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        this.compare(groupA, groupB, differences, false);
        return differences;
    }

    private <T extends VersionedComponent> Set<FlowDifference> compareComponents(Set<T> componentsA, Set<T> componentsB, ComponentComparator<T> comparator) {
        Map componentMapA = this.byId(componentsA == null ? Collections.emptySet() : componentsA);
        Map componentMapB = this.byId(componentsB == null ? Collections.emptySet() : componentsB);
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        componentMapA.entrySet().stream().forEach(entry -> {
            VersionedComponent componentA = (VersionedComponent)entry.getValue();
            VersionedComponent componentB = (VersionedComponent)componentMapB.get(entry.getKey());
            comparator.compare(componentA, componentB, differences);
        });
        componentMapB.entrySet().stream().forEach(entry -> {
            VersionedComponent componentB = (VersionedComponent)entry.getValue();
            VersionedComponent componentA = (VersionedComponent)componentMapA.get(entry.getKey());
            if (componentA == null) {
                comparator.compare(componentA, componentB, differences);
            }
        });
        return differences;
    }

    private boolean compareComponents(VersionedComponent componentA, VersionedComponent componentB, Set<FlowDifference> differences) {
        return this.compareComponents(componentA, componentB, differences, true, true, true);
    }

    private boolean compareComponents(VersionedComponent componentA, VersionedComponent componentB, Set<FlowDifference> differences, boolean compareName, boolean comparePos, boolean compareComments) {
        if (componentA == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_ADDED, componentA, componentB, componentA, componentB));
            return true;
        }
        if (componentB == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_REMOVED, componentA, componentB, componentA, componentB));
            return true;
        }
        if (compareComments) {
            this.addIfDifferent(differences, DifferenceType.COMMENTS_CHANGED, componentA, componentB, VersionedComponent::getComments, false);
        }
        if (compareName) {
            this.addIfDifferent(differences, DifferenceType.NAME_CHANGED, componentA, componentB, VersionedComponent::getName);
        }
        if (comparePos) {
            this.addIfDifferent(differences, DifferenceType.POSITION_CHANGED, componentA, componentB, VersionedComponent::getPosition);
        }
        return false;
    }

    private void compare(VersionedProcessor processorA, VersionedProcessor processorB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)processorA, (VersionedComponent)processorB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, processorA, processorB, VersionedProcessor::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED, processorA, processorB, VersionedProcessor::getAutoTerminatedRelationships);
        this.addIfDifferent(differences, DifferenceType.BULLETIN_LEVEL_CHANGED, processorA, processorB, VersionedProcessor::getBulletinLevel);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, processorA, processorB, VersionedProcessor::getBundle);
        this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, processorA, processorB, VersionedProcessor::getConcurrentlySchedulableTaskCount);
        this.addIfDifferent(differences, DifferenceType.EXECUTION_MODE_CHANGED, processorA, processorB, VersionedProcessor::getExecutionNode);
        this.addIfDifferent(differences, DifferenceType.PENALTY_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getPenaltyDuration);
        this.addIfDifferent(differences, DifferenceType.RUN_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getRunDurationMillis);
        this.addIfDifferent(differences, DifferenceType.RUN_SCHEDULE_CHANGED, processorA, processorB, VersionedProcessor::getSchedulingPeriod);
        this.addIfDifferent(differences, DifferenceType.SCHEDULING_STRATEGY_CHANGED, processorA, processorB, VersionedProcessor::getSchedulingStrategy);
        this.addIfDifferent(differences, DifferenceType.STYLE_CHANGED, processorA, processorB, VersionedProcessor::getStyle);
        this.addIfDifferent(differences, DifferenceType.YIELD_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getYieldDuration);
        this.compareProperties((VersionedComponent)processorA, (VersionedComponent)processorB, processorA.getProperties(), processorB.getProperties(), processorA.getPropertyDescriptors(), processorB.getPropertyDescriptors(), differences);
    }

    @Override
    public Set<FlowDifference> compareControllerServices(VersionedControllerService serviceA, VersionedControllerService serviceB) {
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        this.compare(serviceA, serviceB, differences);
        return differences;
    }

    private void compare(VersionedControllerService serviceA, VersionedControllerService serviceB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)serviceA, (VersionedComponent)serviceB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, serviceA, serviceB, VersionedControllerService::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, serviceA, serviceB, VersionedControllerService::getBundle);
        this.compareProperties((VersionedComponent)serviceA, (VersionedComponent)serviceB, serviceA.getProperties(), serviceB.getProperties(), serviceA.getPropertyDescriptors(), serviceB.getPropertyDescriptors(), differences);
    }

    private void compareProperties(VersionedComponent componentA, VersionedComponent componentB, Map<String, String> propertiesA, Map<String, String> propertiesB, Map<String, VersionedPropertyDescriptor> descriptorsA, Map<String, VersionedPropertyDescriptor> descriptorsB, Set<FlowDifference> differences) {
        propertiesA.entrySet().stream().forEach(entry -> {
            String displayName;
            String valueA = (String)entry.getValue();
            String valueB = (String)propertiesB.get(entry.getKey());
            VersionedPropertyDescriptor descriptor = (VersionedPropertyDescriptor)descriptorsA.get(entry.getKey());
            if (descriptor == null) {
                descriptor = (VersionedPropertyDescriptor)descriptorsB.get(entry.getKey());
            }
            if (descriptor == null) {
                displayName = (String)entry.getKey();
            } else {
                String string = displayName = descriptor.getDisplayName() == null ? descriptor.getName() : descriptor.getDisplayName();
            }
            if (valueA == null && valueB != null) {
                differences.add(this.difference(DifferenceType.PROPERTY_ADDED, componentA, componentB, displayName, displayName));
            } else if (valueA != null && valueB == null) {
                differences.add(this.difference(DifferenceType.PROPERTY_REMOVED, componentA, componentB, displayName, displayName));
            } else if (valueA != null && valueB != null && !valueA.equals(valueB)) {
                if (descriptor.getIdentifiesControllerService()) {
                    boolean accessibleA = this.externallyAccessibleServiceIds.contains(valueA);
                    boolean accessibleB = this.externallyAccessibleServiceIds.contains(valueB);
                    if (!accessibleA && accessibleB) {
                        return;
                    }
                }
                differences.add(this.difference(DifferenceType.PROPERTY_CHANGED, componentA, componentB, displayName + "=" + valueA, displayName + "=" + valueB));
            }
        });
        propertiesB.entrySet().stream().forEach(entry -> {
            String valueA = (String)propertiesA.get(entry.getKey());
            String valueB = (String)entry.getValue();
            if (valueA == null && valueB != null) {
                VersionedPropertyDescriptor descriptor = (VersionedPropertyDescriptor)descriptorsB.get(entry.getKey());
                String displayName = descriptor == null ? (String)entry.getKey() : (descriptor.getDisplayName() == null ? descriptor.getName() : descriptor.getDisplayName());
                differences.add(this.difference(DifferenceType.PROPERTY_ADDED, componentA, componentB, displayName, displayName));
            }
        });
    }

    private void compare(VersionedFunnel funnelA, VersionedFunnel funnelB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)funnelA, (VersionedComponent)funnelB, differences)) {
            return;
        }
    }

    private void compare(VersionedLabel labelA, VersionedLabel labelB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)labelA, (VersionedComponent)labelB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.LABEL_VALUE_CHANGED, labelA, labelB, VersionedLabel::getLabel);
        this.addIfDifferent(differences, DifferenceType.POSITION_CHANGED, labelA, labelB, VersionedLabel::getHeight);
        this.addIfDifferent(differences, DifferenceType.POSITION_CHANGED, labelA, labelB, VersionedLabel::getWidth);
        this.addIfDifferent(differences, DifferenceType.STYLE_CHANGED, labelA, labelB, VersionedLabel::getStyle);
    }

    private void compare(VersionedPort portA, VersionedPort portB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)portA, (VersionedComponent)portB, differences)) {
            return;
        }
    }

    private void compare(VersionedRemoteProcessGroup rpgA, VersionedRemoteProcessGroup rpgB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)rpgA, (VersionedComponent)rpgB, differences, false, true, false)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.RPG_COMMS_TIMEOUT_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getCommunicationsTimeout);
        this.addIfDifferent(differences, DifferenceType.RPG_NETWORK_INTERFACE_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getLocalNetworkInterface);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_HOST_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyHost);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_PORT_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyPort);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_USER_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyUser);
        this.addIfDifferent(differences, DifferenceType.RPG_TRANSPORT_PROTOCOL_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getTransportProtocol);
        this.addIfDifferent(differences, DifferenceType.YIELD_DURATION_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getYieldDuration);
        differences.addAll(this.compareComponents(rpgA.getInputPorts(), rpgB.getInputPorts(), (T a, T b, Set<FlowDifference> diffs) -> this.compare((VersionedRemoteGroupPort)a, (VersionedRemoteGroupPort)b, (Set<FlowDifference>)diffs)));
        differences.addAll(this.compareComponents(rpgA.getOutputPorts(), rpgB.getOutputPorts(), (T a, T b, Set<FlowDifference> diffs) -> this.compare((VersionedRemoteGroupPort)a, (VersionedRemoteGroupPort)b, (Set<FlowDifference>)diffs)));
    }

    private void compare(VersionedRemoteGroupPort portA, VersionedRemoteGroupPort portB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)portA, (VersionedComponent)portB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.REMOTE_PORT_BATCH_SIZE_CHANGED, portA, portB, VersionedRemoteGroupPort::getBatchSize);
        this.addIfDifferent(differences, DifferenceType.REMOTE_PORT_COMPRESSION_CHANGED, portA, portB, VersionedRemoteGroupPort::isUseCompression);
        this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, portA, portB, VersionedRemoteGroupPort::getConcurrentlySchedulableTaskCount);
    }

    private void compare(VersionedProcessGroup groupA, VersionedProcessGroup groupB, Set<FlowDifference> differences, boolean compareNamePos) {
        if (this.compareComponents((VersionedComponent)groupA, (VersionedComponent)groupB, differences, compareNamePos, compareNamePos, true)) {
            return;
        }
        if (groupA == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_ADDED, (VersionedComponent)groupA, (VersionedComponent)groupB, groupA, groupB));
            return;
        }
        if (groupB == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_REMOVED, (VersionedComponent)groupA, (VersionedComponent)groupB, groupA, groupB));
            return;
        }
        this.addIfDifferent(differences, DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, groupA, groupB, VersionedProcessGroup::getVersionedFlowCoordinates);
        if (groupA != null && groupB != null && groupA.getVersionedFlowCoordinates() == null && groupB.getVersionedFlowCoordinates() == null) {
            differences.addAll(this.compareComponents(groupA.getConnections(), groupB.getConnections(), this::compare));
            differences.addAll(this.compareComponents(groupA.getProcessors(), groupB.getProcessors(), this::compare));
            differences.addAll(this.compareComponents(groupA.getControllerServices(), groupB.getControllerServices(), this::compare));
            differences.addAll(this.compareComponents(groupA.getFunnels(), groupB.getFunnels(), this::compare));
            differences.addAll(this.compareComponents(groupA.getInputPorts(), groupB.getInputPorts(), this::compare));
            differences.addAll(this.compareComponents(groupA.getLabels(), groupB.getLabels(), this::compare));
            differences.addAll(this.compareComponents(groupA.getOutputPorts(), groupB.getOutputPorts(), this::compare));
            differences.addAll(this.compareComponents(groupA.getProcessGroups(), groupB.getProcessGroups(), (T a, T b, Set<FlowDifference> diffs) -> this.compare((VersionedProcessGroup)a, (VersionedProcessGroup)b, diffs, true)));
            differences.addAll(this.compareComponents(groupA.getRemoteProcessGroups(), groupB.getRemoteProcessGroups(), this::compare));
        }
    }

    private void compare(VersionedConnection connectionA, VersionedConnection connectionB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)connectionA, (VersionedComponent)connectionB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.BACKPRESSURE_DATA_SIZE_THRESHOLD_CHANGED, connectionA, connectionB, VersionedConnection::getBackPressureDataSizeThreshold);
        this.addIfDifferent(differences, DifferenceType.BACKPRESSURE_OBJECT_THRESHOLD_CHANGED, connectionA, connectionB, VersionedConnection::getBackPressureObjectThreshold);
        this.addIfDifferent(differences, DifferenceType.BENDPOINTS_CHANGED, connectionA, connectionB, VersionedConnection::getBends);
        this.addIfDifferent(differences, DifferenceType.DESTINATION_CHANGED, connectionA, connectionB, VersionedConnection::getDestination);
        this.addIfDifferent(differences, DifferenceType.FLOWFILE_EXPIRATION_CHANGED, connectionA, connectionB, VersionedConnection::getFlowFileExpiration);
        this.addIfDifferent(differences, DifferenceType.PRIORITIZERS_CHANGED, connectionA, connectionB, VersionedConnection::getPrioritizers);
        this.addIfDifferent(differences, DifferenceType.SELECTED_RELATIONSHIPS_CHANGED, connectionA, connectionB, VersionedConnection::getSelectedRelationships);
        this.addIfDifferent(differences, DifferenceType.SOURCE_CHANGED, connectionA, connectionB, c -> c.getSource().getId());
    }

    private <T extends VersionedComponent> Map<String, T> byId(Set<T> components) {
        return components.stream().collect(Collectors.toMap(VersionedComponent::getIdentifier, Function.identity()));
    }

    private <T extends VersionedComponent> void addIfDifferent(Set<FlowDifference> differences, DifferenceType type, T componentA, T componentB, Function<T, Object> transform) {
        this.addIfDifferent(differences, type, componentA, componentB, transform, true);
    }

    private <T extends VersionedComponent> void addIfDifferent(Set<FlowDifference> differences, DifferenceType type, T componentA, T componentB, Function<T, Object> transform, boolean differentiateNullAndEmptyString) {
        Object valueB;
        Object valueA = transform.apply(componentA);
        if (Objects.equals(valueA, valueB = transform.apply(componentB))) {
            return;
        }
        if ((valueA == null || valueA instanceof Collection) && (valueB == null || valueB instanceof Collection) && this.isEmpty((Collection)valueA) && this.isEmpty((Collection)valueB)) {
            return;
        }
        if (!differentiateNullAndEmptyString && this.isEmptyString(valueA) && this.isEmptyString(valueB)) {
            return;
        }
        differences.add(this.difference(type, componentA, componentB, valueA, valueB));
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmptyString(Object potentialString) {
        if (potentialString == null) {
            return true;
        }
        if (potentialString instanceof String) {
            String string = (String)potentialString;
            return string.isEmpty();
        }
        return false;
    }

    private FlowDifference difference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, Object valueA, Object valueB) {
        String description = this.differenceDescriptor.describeDifference(type, this.flowA.getName(), this.flowB.getName(), componentA, componentB, valueA, valueB);
        return new StandardFlowDifference(type, componentA, componentB, valueA, valueB, description);
    }

    private static interface ComponentComparator<T extends VersionedComponent> {
        public void compare(T var1, T var2, Set<FlowDifference> var3);
    }
}

