/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;

public class StandardFlowDifference
implements FlowDifference {
    private final DifferenceType type;
    private final VersionedComponent componentA;
    private final VersionedComponent componentB;
    private final Object valueA;
    private final Object valueB;
    private final String description;

    public StandardFlowDifference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, Object valueA, Object valueB, String description) {
        this.type = type;
        this.componentA = componentA;
        this.componentB = componentB;
        this.valueA = valueA;
        this.valueB = valueB;
        this.description = description;
    }

    @Override
    public DifferenceType getDifferenceType() {
        return this.type;
    }

    @Override
    public VersionedComponent getComponentA() {
        return this.componentA;
    }

    @Override
    public VersionedComponent getComponentB() {
        return this.componentB;
    }

    @Override
    public Object getValueA() {
        return this.valueA;
    }

    @Override
    public Object getValueB() {
        return this.valueB;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return 31 + 17 * (this.componentA == null ? 0 : this.componentA.getIdentifier().hashCode()) + 17 * (this.componentB == null ? 0 : this.componentB.getIdentifier().hashCode()) + Objects.hash(new Object[]{this.description, this.type, this.valueA, this.valueB});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardFlowDifference)) {
            return false;
        }
        StandardFlowDifference other = (StandardFlowDifference)obj;
        String componentAId = this.componentA == null ? null : this.componentA.getIdentifier();
        String otherComponentAId = other.componentA == null ? null : other.componentA.getIdentifier();
        String componentBId = this.componentB == null ? null : this.componentB.getIdentifier();
        String otherComponentBId = other.componentB == null ? null : other.componentB.getIdentifier();
        return Objects.equals(componentAId, otherComponentAId) && Objects.equals(componentBId, otherComponentBId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.valueA, other.valueA) && Objects.equals(this.valueB, other.valueB);
    }
}

