/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;

public class StaticDifferenceDescriptor
implements DifferenceDescriptor {
    @Override
    public String describeDifference(DifferenceType type, String flowAName, String flowBName, VersionedComponent componentA, VersionedComponent componentB, Object valueA, Object valueB) {
        String description;
        switch (type) {
            case COMPONENT_ADDED: {
                description = String.format("%s with ID %s exists in %s but not in %s", componentB.getComponentType().getTypeName(), componentB.getIdentifier(), flowBName, flowAName);
                break;
            }
            case COMPONENT_REMOVED: {
                description = String.format("%s with ID %s exists in %s but not in %s", componentA.getComponentType().getTypeName(), componentA.getIdentifier(), flowAName, flowBName);
                break;
            }
            case PROPERTY_ADDED: {
                description = String.format("Property '%s' exists for %s with ID %s in %s but not in %s", valueB, componentB.getComponentType().getTypeName(), componentB.getIdentifier(), flowBName, flowAName);
                break;
            }
            case PROPERTY_REMOVED: {
                description = String.format("Property '%s' exists for %s with ID %s in %s but not in %s", valueA, componentA.getComponentType().getTypeName(), componentA.getIdentifier(), flowAName, flowBName);
                break;
            }
            case VARIABLE_ADDED: {
                description = String.format("Variable '%s' exists for Process Group with ID %s in %s but not in %s", valueB, componentB.getIdentifier(), flowBName, flowAName);
                break;
            }
            case VARIABLE_REMOVED: {
                description = String.format("Variable '%s' exists for Process Group with ID %s in %s but not in %s", valueA, componentA.getIdentifier(), flowAName, flowBName);
                break;
            }
            case VERSIONED_FLOW_COORDINATES_CHANGED: {
                if (valueA instanceof VersionedFlowCoordinates && valueB instanceof VersionedFlowCoordinates) {
                    VersionedFlowCoordinates coordinatesA = (VersionedFlowCoordinates)valueA;
                    VersionedFlowCoordinates coordinatesB = (VersionedFlowCoordinates)valueB;
                    if (Objects.equals(coordinatesA.getRegistryUrl(), coordinatesB.getRegistryUrl()) && Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && coordinatesA.getVersion() != coordinatesB.getVersion()) {
                        description = String.format("Flow Version is %s in %s but %s in %s", coordinatesA.getVersion(), flowAName, coordinatesB.getVersion(), flowBName);
                        break;
                    }
                }
                description = String.format("%s for %s with ID %s; flow '%s' has value %s; flow '%s' has value %s", type.getDescription(), componentA.getComponentType().getTypeName(), componentA.getIdentifier(), flowAName, valueA, flowBName, valueB);
                break;
            }
            default: {
                description = String.format("%s for %s with ID %s; flow '%s' has value %s; flow '%s' has value %s", type.getDescription(), componentA.getComponentType().getTypeName(), componentA.getIdentifier(), flowAName, valueA, flowBName, valueB);
            }
        }
        return description;
    }
}

