/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedEntitiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProxiedEntitiesUtils.class);
    public static final String PROXY_ENTITIES_CHAIN = "X-ProxiedEntitiesChain";
    public static final String PROXY_ENTITIES_ACCEPTED = "X-ProxiedEntitiesAccepted";
    public static final String PROXY_ENTITIES_DETAILS = "X-ProxiedEntitiesDetails";
    private static final String GT = ">";
    private static final String ESCAPED_GT = "\\\\>";
    private static final String LT = "<";
    private static final String ESCAPED_LT = "\\\\<";
    private static final String ANONYMOUS_CHAIN = "<>";

    public static String formatProxyDn(String dn) {
        return LT + ProxiedEntitiesUtils.sanitizeDn(dn) + GT;
    }

    private static String sanitizeDn(String rawDn) {
        if (StringUtils.isEmpty((CharSequence)rawDn)) {
            return rawDn;
        }
        String sanitizedDn = rawDn.replaceAll(GT, ESCAPED_GT).replaceAll(LT, ESCAPED_LT);
        if (!sanitizedDn.equals(rawDn)) {
            logger.warn("The provided DN [" + rawDn + "] contained dangerous characters that were escaped to [" + sanitizedDn + "]");
        }
        return sanitizedDn;
    }

    private static String unsanitizeDn(String sanitizedDn) {
        if (StringUtils.isEmpty((CharSequence)sanitizedDn)) {
            return sanitizedDn;
        }
        String unsanitizedDn = sanitizedDn.replaceAll(ESCAPED_GT, GT).replaceAll(ESCAPED_LT, LT);
        if (!unsanitizedDn.equals(sanitizedDn)) {
            logger.warn("The provided DN [" + sanitizedDn + "] had been escaped, and was reconstituted to the dangerous DN [" + unsanitizedDn + "]");
        }
        return unsanitizedDn;
    }

    public static List<String> tokenizeProxiedEntitiesChain(String rawProxyChain) {
        ArrayList<String> proxyChain = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)rawProxyChain)) {
            List<String> elements = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawProxyChain, (String)"><"));
            elements = elements.stream().map(ProxiedEntitiesUtils::unsanitizeDn).collect(Collectors.toList());
            elements.set(0, elements.get(0).replaceFirst(LT, ""));
            int last = elements.size() - 1;
            String lastElement = elements.get(last);
            if (lastElement.endsWith(GT)) {
                elements.set(last, lastElement.substring(0, lastElement.length() - 1));
            }
            proxyChain.addAll(elements);
        }
        return proxyChain;
    }
}

