/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public abstract class Valuable
extends Annotatable {
    private ValueType valueType = null;
    private Object value = null;
    private String type;

    public boolean isNull() {
        return this.value == null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrimitive() {
        if (this.isCollection()) {
            return this.valueType.getBaseType() == ValueType.PRIMITIVE;
        }
        return this.valueType == ValueType.PRIMITIVE;
    }

    public boolean isGeospatial() {
        if (this.isCollection()) {
            return this.valueType.getBaseType() == ValueType.GEOSPATIAL;
        }
        return this.valueType == ValueType.GEOSPATIAL;
    }

    public boolean isEnum() {
        if (this.isCollection()) {
            return this.valueType.getBaseType() == ValueType.ENUM;
        }
        return this.valueType == ValueType.ENUM;
    }

    public boolean isComplex() {
        if (this.isCollection()) {
            return this.valueType.getBaseType() == ValueType.COMPLEX;
        }
        return this.valueType == ValueType.COMPLEX;
    }

    public boolean isCollection() {
        return this.valueType != null && this.valueType != this.valueType.getBaseType();
    }

    public Object asPrimitive() {
        if (this.isCollection()) {
            return null;
        }
        return this.isPrimitive() ? this.value : null;
    }

    public Geospatial asGeospatial() {
        if (this.isCollection()) {
            return null;
        }
        return this.isGeospatial() ? (Geospatial)this.value : null;
    }

    public Object asEnum() {
        if (this.isCollection()) {
            return null;
        }
        return this.isEnum() ? this.value : null;
    }

    public ComplexValue asComplex() {
        if (this.isCollection()) {
            return null;
        }
        return this.isComplex() ? (ComplexValue)this.value : null;
    }

    public List<?> asCollection() {
        return this.isCollection() ? (List)this.value : null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(ValueType valueType, Object value) {
        this.valueType = valueType;
        this.value = value;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

