/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.io.Serializable;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public final class SRID
implements Serializable {
    private static final String VARIABLE = "variable";
    private static final long serialVersionUID = 8412685060902464629L;
    private Geospatial.Dimension dimension = Geospatial.Dimension.GEOGRAPHY;
    private Integer value;
    private Boolean variable;

    public static SRID valueOf(String exp) {
        SRID instance = new SRID();
        if (VARIABLE.equalsIgnoreCase(exp)) {
            instance.variable = Boolean.TRUE;
        } else {
            instance.value = Integer.valueOf(exp);
            if (instance.value < 0) {
                throw new IllegalArgumentException("The value of the SRID attribute MUST be a non-negative integer or the special value 'variable'");
            }
        }
        return instance;
    }

    protected SRID() {
    }

    public Geospatial.Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Geospatial.Dimension dimension) {
        this.dimension = dimension;
    }

    private String getValue() {
        if (this.value == null) {
            if (this.dimension == Geospatial.Dimension.GEOMETRY) {
                return "0";
            }
            return "4326";
        }
        return this.value.toString();
    }

    private boolean isVariable() {
        return this.variable != null && this.variable != false;
    }

    public boolean isNotDefault() {
        return this.value != null || this.variable != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SRID srid = (SRID)o;
        if (this.dimension != srid.dimension) {
            return false;
        }
        if (this.value != null ? !this.value.equals(srid.value) : srid.value != null) {
            return false;
        }
        return !(this.variable == null ? srid.variable != null : !this.variable.equals(srid.variable));
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.variable != null ? this.variable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isVariable() ? VARIABLE : this.getValue();
    }
}

