/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.TypeUtil;

public final class AcceptType {
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private final Float quality;

    private AcceptType(String type, String subtype, Map<String, String> parameters, Float quality) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = TypeUtil.createParameterMap();
        this.parameters.putAll(parameters);
        this.quality = quality;
    }

    private AcceptType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type parameter MUST NOT be null.");
        }
        ArrayList<String> typeSubtype = new ArrayList<String>();
        this.parameters = TypeUtil.createParameterMap();
        AcceptType.parse(type, typeSubtype, this.parameters);
        this.type = (String)typeSubtype.get(0);
        this.subtype = (String)typeSubtype.get(1);
        if ("*".equals(this.type) && !"*".equals(this.subtype)) {
            throw new IllegalArgumentException("Illegal combination of WILDCARD type with NONE WILDCARD subtype.");
        }
        String q = this.parameters.get("q");
        if (q == null) {
            this.quality = Float.valueOf(1.0f);
        } else {
            try {
                this.quality = Float.valueOf(q);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal quality parameter.", e);
            }
        }
    }

    private static void parse(String format, List<String> typeSubtype, Map<String, String> parameters) {
        String[] typesAndParameters = format.split(";", 2);
        String types = typesAndParameters[0];
        String params = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        String[] tokens = types.split("/");
        if (tokens.length == 2) {
            if (tokens[0] == null || tokens[0].isEmpty()) {
                throw new IllegalArgumentException("No type found in format '" + format + "'.");
            }
            if (tokens[1] == null || tokens[1].isEmpty()) {
                throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
            }
        } else {
            throw new IllegalArgumentException("Not exactly one '/' in format '" + format + "', or it is at the beginning or at the end.");
        }
        typeSubtype.add(tokens[0]);
        typeSubtype.add(tokens[1]);
        TypeUtil.parseParameters(params, parameters);
    }

    public static List<AcceptType> create(String acceptTypes) {
        String[] values;
        ArrayList<AcceptType> result = new ArrayList<AcceptType>();
        for (String value : values = acceptTypes.split(",")) {
            result.add(new AcceptType(value.trim()));
        }
        AcceptType.sort(result);
        return result;
    }

    public static List<AcceptType> fromContentType(ContentType contentType) {
        return Collections.singletonList(new AcceptType(contentType.getType(), contentType.getSubtype(), contentType.getParameters(), Float.valueOf(1.0f)));
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase(Locale.ROOT));
    }

    public Float getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type).append('/').append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result.append(';').append(entry.getKey()).append('=').append(entry.getValue());
        }
        return result.toString();
    }

    public boolean matches(ContentType contentType) {
        if (this.type.equals("*")) {
            return true;
        }
        if (!this.type.equalsIgnoreCase(contentType.getType())) {
            return false;
        }
        if (this.subtype.equals("*")) {
            return true;
        }
        if (!this.subtype.equalsIgnoreCase(contentType.getSubtype())) {
            return false;
        }
        Map<String, String> compareParameters = contentType.getParameters();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (compareParameters.containsKey(entry.getKey()) || "q".equalsIgnoreCase(entry.getKey())) {
                String compare = compareParameters.get(entry.getKey());
                if (entry.getValue().equalsIgnoreCase(compare) || "q".equalsIgnoreCase(entry.getKey())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static void sort(List<AcceptType> toSort) {
        Collections.sort(toSort, new Comparator<AcceptType>(){

            @Override
            public int compare(AcceptType a1, AcceptType a2) {
                int compare = a2.getQuality().compareTo(a1.getQuality());
                if (compare != 0) {
                    return compare;
                }
                compare = (a1.getType().equals("*") ? 1 : 0) - (a2.getType().equals("*") ? 1 : 0);
                if (compare != 0) {
                    return compare;
                }
                compare = (a1.getSubtype().equals("*") ? 1 : 0) - (a2.getSubtype().equals("*") ? 1 : 0);
                if (compare != 0) {
                    return compare;
                }
                return a2.getParameters().size() - a1.getParameters().size();
            }
        });
    }
}

