/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.commons.api.edm.provider;

import java.util.ArrayList;
import java.util.List;

/**
 * The type Csdl operation import.
 */
public abstract class CsdlOperationImport extends CsdlAbstractEdmItem implements CsdlNamed, CsdlAnnotatable {

  private static final long serialVersionUID = -8928186067970681061L;

  /**
   * The Name.
   */
  protected String name;
  /**
   * The Entity set.
   */
  protected String entitySet;
  /**
   * The Annotations.
   */
  protected final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

  @Override
  public String getName() {
    return name;
  }

  /**
   * Sets name.
   *
   * @param name the name
   * @return the name
   */
  public CsdlOperationImport setName(final String name) {
    this.name = name;
    return this;
  }

  /**
   * Gets entity set.
   *
   * @return the entity set
   */
  public String getEntitySet() {
    return entitySet;
  }

  /**
   * Sets entity set.
   *
   * @param entitySet the entity set
   * @return the entity set
   */
  public CsdlOperationImport setEntitySet(final String entitySet) {
    this.entitySet = entitySet;
    return this;
  }

  @Override
  public List<CsdlAnnotation> getAnnotations() {
    return annotations;
  }
}
