/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.constants;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ODataServiceVersion {
    V10("1.0"),
    V20("2.0"),
    V30("3.0"),
    V40("4.0");

    private static final Pattern DATASERVICEVERSIONPATTERN;
    private final String version;

    public static boolean validateDataServiceVersion(String version) {
        Matcher matcher = DATASERVICEVERSIONPATTERN.matcher(version);
        if (matcher.matches()) {
            String possibleDataServiceVersion = matcher.group(1);
            return V10.toString().equals(possibleDataServiceVersion) || V20.toString().equals(possibleDataServiceVersion) || V30.toString().equals(possibleDataServiceVersion) || V40.toString().equals(possibleDataServiceVersion);
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isBiggerThan(String actual, String comparedTo) {
        double other;
        if (!ODataServiceVersion.validateDataServiceVersion(comparedTo) || !ODataServiceVersion.validateDataServiceVersion(actual)) {
            throw new IllegalArgumentException("Illegal arguments: " + comparedTo + " and " + actual);
        }
        double me = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(actual));
        return me > (other = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString(comparedTo)));
    }

    private static String extractDataServiceVersionString(String rawDataServiceVersion) {
        if (rawDataServiceVersion != null) {
            String[] pattern = rawDataServiceVersion.split(";");
            return pattern[0];
        }
        return null;
    }

    private ODataServiceVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    static {
        DATASERVICEVERSIONPATTERN = Pattern.compile("(\\p{Digit}+\\.\\p{Digit}+)(:?;.*)?");
    }
}

