/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.Locale;
import java.util.Map;

class TypeUtil {
    static final String MEDIA_TYPE_WILDCARD = "*";
    static final String PARAMETER_Q = "q";
    static final char WHITESPACE_CHAR = ' ';
    static final String PARAMETER_SEPARATOR = ";";
    static final String PARAMETER_KEY_VALUE_SEPARATOR = "=";
    static final String TYPE_SUBTYPE_SEPARATOR = "/";
    static final String TYPE_SUBTYPE_WILDCARD = "*";

    TypeUtil() {
    }

    protected static void parseParameters(String parameters, Map<String, String> parameterMap) {
        if (parameters != null) {
            for (String parameter : parameters.split(PARAMETER_SEPARATOR)) {
                String[] keyValue = TypeUtil.parseParameter(parameter);
                parameterMap.put(keyValue[0], keyValue[1]);
            }
        }
    }

    protected static String[] parseParameter(String parameter) {
        if (parameter.isEmpty()) {
            throw new IllegalArgumentException("An empty parameter is not allowed.");
        }
        String[] keyValue = parameter.trim().split(PARAMETER_KEY_VALUE_SEPARATOR);
        if (keyValue.length != 2 || keyValue[0].isEmpty()) {
            throw new IllegalArgumentException("Parameter '" + parameter + "' must have exactly one '" + PARAMETER_KEY_VALUE_SEPARATOR + "' that separates the name and the value.");
        }
        keyValue[0] = keyValue[0].toLowerCase(Locale.ENGLISH);
        if (keyValue[0].indexOf(32) >= 0) {
            throw new IllegalArgumentException("Parameter name '" + keyValue[0] + "' contains whitespace.");
        }
        if (Character.isWhitespace(keyValue[1].charAt(0))) {
            throw new IllegalArgumentException("Value of parameter '" + keyValue[0] + "' starts with whitespace.");
        }
        return keyValue;
    }
}

