/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Olingo Server API
 * <p>
 * OData Library is a protocol implementation of the OData V4.0 standard. For details of this standard
 * see <a href="http://odata.org">odata.org</a>.
 * <p>
 * This API is intended to help implement an OData service. An OData service consists of a metadata provider
 * implementation and an OData processor implementation.
 * <p>
 * An OData service can be exposed by a web application using the standard java servlet API. See the Olingo tutorials
 * section on how to implement a V4 service for further information:
 * <a href="http://olingo.apache.org/doc/odata4/index.html">http://olingo.apache.org/doc/odata4/index.html
 * <p>
 * The main entry point is the org.apache.olingo.server.api.OData class. Use the newInstance() method to create a new
 * object and start providing your service from there.
 * 
 */
package org.apache.olingo.server.api;

