/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpHeaders {
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

    public HttpHeaders addHeader(String name, String value) {
        String canonicalName = this.getCanonicalName(name);
        List<String> header = this.headers.get(canonicalName);
        if (header == null) {
            header = new ArrayList<String>();
        }
        header.add(value);
        this.headers.put(canonicalName, header);
        return this;
    }

    public HttpHeaders addHeader(String name, List<String> values) {
        String canonicalName = this.getCanonicalName(name);
        List<String> header = this.headers.get(canonicalName);
        if (header == null) {
            header = new ArrayList<String>();
        }
        header.addAll(values);
        this.headers.put(canonicalName, header);
        return this;
    }

    public HttpHeaders setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
        return this;
    }

    public List<String> getHeader(String name) {
        List<String> values = this.headers.get(this.getCanonicalName(name));
        return values == null || values.isEmpty() ? null : Collections.unmodifiableList(values);
    }

    public List<String> removeHeader(String name) {
        return this.headers.remove(this.getCanonicalName(name));
    }

    public Map<String, List<String>> getHeaderToValues() {
        return this.headers.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.headers);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.headers.keySet());
    }

    private String getCanonicalName(String name) {
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }
}

