/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.serializer;

import org.apache.olingo.commons.api.edm.EdmProperty;

public class PrimitiveValueSerializerOptions {
    private Boolean isNullable;
    private Integer maxLength;
    private Integer precision;
    private Integer scale;
    private Boolean isUnicode;

    public Boolean isNullable() {
        return this.isNullable;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Boolean isUnicode() {
        return this.isUnicode;
    }

    private PrimitiveValueSerializerOptions() {
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private PrimitiveValueSerializerOptions options = new PrimitiveValueSerializerOptions();

        private Builder() {
        }

        public Builder nullable(Boolean isNullable) {
            this.options.isNullable = isNullable;
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.options.maxLength = maxLength;
            return this;
        }

        public Builder precision(Integer precision) {
            this.options.precision = precision;
            return this;
        }

        public Builder scale(Integer scale) {
            this.options.scale = scale;
            return this;
        }

        public Builder unicode(Boolean isUnicode) {
            this.options.isUnicode = isUnicode;
            return this;
        }

        public Builder facetsFrom(EdmProperty property) {
            this.options.isNullable = property.isNullable();
            this.options.maxLength = property.getMaxLength();
            this.options.precision = property.getPrecision();
            this.options.scale = property.getScale();
            this.options.isUnicode = property.isUnicode();
            return this;
        }

        public PrimitiveValueSerializerOptions build() {
            return this.options;
        }
    }
}

