/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.model;

import java.sql.Clob;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.jpa.processor.ref.converter.ClobToStringConverter;
import org.apache.olingo.odata2.jpa.processor.ref.model.NoteKey;
import org.apache.olingo.odata2.jpa.processor.ref.model.SalesOrderHeader;

@Entity
@IdClass(value=NoteKey.class)
@Table(name="T_NOTE")
public class Note {
    @Id
    @Temporal(value=TemporalType.TIME)
    private Calendar creationTime;
    @Id
    @Temporal(value=TemporalType.DATE)
    private Calendar creationDate;
    @Id
    private String createdBy;
    @Column
    @Lob
    @Convert(converter=ClobToStringConverter.class)
    private Clob text;
    @Column(name="SO_ID")
    private long soId;
    @JoinColumn(name="SO_ID", referencedColumnName="SO_ID", insertable=false, updatable=false)
    @ManyToOne
    private SalesOrderHeader salesOrderHeader;

    public Note() {
    }

    public Note(Calendar creationTime, Calendar creationDate, String createdBy) {
        this.creationTime = creationTime;
        this.creationDate = creationDate;
        this.createdBy = createdBy;
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Clob getText() {
        return this.text;
    }

    public void setText(Clob text) {
        this.text = text;
    }

    public long getSoId() {
        return this.soId;
    }

    public void setSoId(long soId) {
        this.soId = soId;
    }

    public SalesOrderHeader getSalesOrderHeader() {
        return this.salesOrderHeader;
    }

    public void setSalesOrderHeader(SalesOrderHeader salesOrderHeader) {
        this.salesOrderHeader = salesOrderHeader;
        this.salesOrderHeader.getNotes().add(this);
    }
}

