/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.jpa.processor.ref.listeners.SalesOrderTombstoneListener;
import org.apache.olingo.odata2.jpa.processor.ref.model.Customer;
import org.apache.olingo.odata2.jpa.processor.ref.model.Note;
import org.apache.olingo.odata2.jpa.processor.ref.model.SalesOrderItem;

@Entity
@Table(name="T_SALESORDERHEADER")
@EntityListeners(value={SalesOrderTombstoneListener.class})
public class SalesOrderHeader {
    @Id
    @Column(name="SO_ID")
    private long soId;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate;
    @Column
    private Character status;
    @Column(name="SHORT_TEXT", length=20)
    private char[] shortText;
    @Column(name="LONG_TEXT", length=40)
    private Character[] longText;
    @Column(name="CURRENCY_CODE", length=3)
    private String currencyCode;
    @Column(name="DELIVERY_STATUS", length=2)
    private String deliveryStatus;
    @Column(precision=5)
    private double grossAmount;
    @Column(precision=8)
    private double netAmount;
    @OneToMany(mappedBy="salesOrderHeader", cascade={CascadeType.ALL})
    private Set<SalesOrderItem> salesOrderItem = new HashSet<SalesOrderItem>();
    @OneToMany(mappedBy="salesOrderHeader")
    private List<Note> notes = new ArrayList<Note>();
    @ManyToOne
    @JoinColumn
    private Customer customer;

    public SalesOrderHeader() {
    }

    public SalesOrderHeader(Calendar creationDate, String currencyCode, double netAmount, String deliveryStatus, char[] shortText, Character[] longText) {
        this.creationDate = creationDate;
        this.currencyCode = currencyCode;
        this.deliveryStatus = deliveryStatus;
        this.shortText = shortText;
        this.longText = longText;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Character getStatus() {
        return this.status;
    }

    public void setStatus(Character status) {
        this.status = status;
    }

    public long getSoId() {
        return this.soId;
    }

    public void setSoId(long soId) {
        this.soId = soId;
    }

    public Calendar getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public double getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(double grossAmount) {
        this.grossAmount = grossAmount;
    }

    public double getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(double netAmount) {
        this.netAmount = netAmount;
    }

    public Set<SalesOrderItem> getSalesOrderItem() {
        return this.salesOrderItem;
    }

    public void setSalesOrderItem(Set<SalesOrderItem> salesOrderItem) {
        this.salesOrderItem = salesOrderItem;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public char[] getShortText() {
        return this.shortText;
    }

    public void setShortText(char[] shortText) {
        this.shortText = shortText;
    }

    public Character[] getLongText() {
        return this.longText;
    }

    public void setLongText(Character[] longText) {
        this.longText = longText;
    }

    @PostPersist
    public void defaultValues() {
        if (this.creationDate == null) {
            this.setCreationDate(this.creationDate);
        }
    }
}

