/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.util;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPADefaultProcessor;

public class CustomODataJPAProcessor
extends ODataJPADefaultProcessor {
    private static final Logger LOG = Logger.getLogger(CustomODataJPAProcessor.class.getName());
    private static final AtomicInteger READ_COUNT = new AtomicInteger(0);

    public CustomODataJPAProcessor(ODataJPAContext oDataJPAContext) {
        super(oDataJPAContext);
    }

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriParserResultView, String contentType) throws ODataException {
        int readCount = READ_COUNT.incrementAndGet();
        LOG.log(Level.INFO, "Start read access number '" + readCount + "' for '" + uriParserResultView.getTargetEntitySet().getName() + "'.");
        long start = System.currentTimeMillis();
        List jpaEntities = this.jpaProcessor.process(uriParserResultView);
        ODataResponse oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntities, contentType);
        long duration = System.currentTimeMillis() - start;
        LOG.log(Level.INFO, "Finished read access number '" + readCount + "' after '" + duration + "'ms.");
        return oDataResponse;
    }
}

