/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.model;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.olingo.odata2.jpa.processor.ref.listeners.SalesOrderItemTombstoneListener;
import org.apache.olingo.odata2.jpa.processor.ref.model.Material;
import org.apache.olingo.odata2.jpa.processor.ref.model.SalesOrderHeader;
import org.apache.olingo.odata2.jpa.processor.ref.model.SalesOrderItemKey;

@Entity
@Table(name="T_SALESORDERITEM")
@EntityListeners(value={SalesOrderItemTombstoneListener.class})
public class SalesOrderItem {
    @EmbeddedId
    private SalesOrderItemKey salesOrderItemKey;
    @Column
    private int quantity;
    @Column
    private double amount;
    @Column
    private double discount;
    @Transient
    private double netAmount;
    @Column
    private boolean delivered;
    @JoinColumn(name="Material_Id")
    @ManyToOne
    private Material material;
    @JoinColumn(name="Sales_Order_Id", referencedColumnName="SO_ID", insertable=false, updatable=false)
    @ManyToOne
    private SalesOrderHeader salesOrderHeader;

    public SalesOrderItem() {
    }

    public SalesOrderItem(int quantity, double amount, double discount, Material material) {
        this.quantity = quantity;
        this.amount = amount;
        this.discount = discount;
        this.material = material;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered(boolean deliveryStatus) {
        this.delivered = deliveryStatus;
    }

    public SalesOrderItemKey getSalesOrderItemKey() {
        return this.salesOrderItemKey;
    }

    public void setSalesOrderItemKey(SalesOrderItemKey salesOrderItemKey) {
        this.salesOrderItemKey = salesOrderItemKey;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(double netAmount) {
        this.netAmount = netAmount;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public SalesOrderHeader getSalesOrderHeader() {
        return this.salesOrderHeader;
    }

    public void setSalesOrderHeader(SalesOrderHeader salesOrderHeader) {
        this.salesOrderHeader = salesOrderHeader;
    }
}

