/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Calendar;
import org.apache.olingo.odata2.ref.model.Location;
import org.apache.olingo.odata2.ref.model.Manager;
import org.apache.olingo.odata2.ref.model.ModelException;
import org.apache.olingo.odata2.ref.model.Room;
import org.apache.olingo.odata2.ref.model.Team;

public class Employee {
    private int employeeId;
    private String employeeName;
    private Integer age;
    private Manager manager;
    private Team team;
    private Room room;
    private String imageType;
    private byte[] image;
    private String imageUrl;
    private Calendar entryDate;
    private Location location;

    public Employee(int employeeId, String name) {
        this.employeeId = employeeId;
        this.setEmployeeName(name);
    }

    public String getId() {
        return Integer.toString(this.employeeId);
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setImageUri(String imageUri) {
        this.imageUrl = imageUri;
    }

    public String getImageUri() {
        return this.imageUrl;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setEntryDate(Calendar date) {
        this.entryDate = date;
    }

    public Calendar getEntryDate() {
        return this.entryDate;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public void setImage(String imageUrl) {
        this.image = Employee.loadImage(imageUrl);
    }

    private static byte[] loadImage(String imageUrl) {
        try {
            InputStream in = Employee.class.getResourceAsStream(imageUrl);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int b = 0;
            while ((b = in.read()) != -1) {
                stream.write(b);
            }
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new ModelException(e);
        }
    }

    public byte[] getImage() {
        if (this.image == null) {
            return null;
        }
        return (byte[])this.image.clone();
    }

    public int hashCode() {
        return this.employeeId;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.employeeId == ((Employee)obj).employeeId;
    }

    public String toString() {
        return "{\"EmployeeId\":\"" + this.employeeId + "\",\"EmployeeName\":\"" + this.employeeName + "\",\"ManagerId\":" + (this.manager == null ? "null" : "\"" + this.manager.getId() + "\"") + ",\"RoomId\":" + (this.room == null ? "null" : "\"" + this.room.getId() + "\"") + ",\"TeamId\":" + (this.team == null ? "null" : "\"" + this.team.getId() + "\"") + ",\"Location\":" + (this.location == null ? "null" : "{\"City\":" + (this.location.getCity() == null ? "null" : "{\"PostalCode\":\"" + this.location.getCity().getPostalCode() + "\",\"CityName\":\"" + this.location.getCity().getCityName() + "\"}") + ",\"Country\":\"" + this.location.getCountry() + "\"}") + ",\"Age\":" + this.age + ",\"EntryDate\":" + (this.entryDate == null ? "null" : "\"" + DateFormat.getInstance().format(this.entryDate.getTime()) + "\"") + ",\"ImageUrl\":\"" + this.imageUrl + "\"}";
    }
}

