/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.edm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmAction;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.CustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.FunctionImportParameter;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.OnDelete;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.ReturnType;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.exception.ODataException;

public class ScenarioEdmProvider
extends EdmProvider {
    public static final String NAMESPACE_1 = "RefScenario";
    public static final String NAMESPACE_2 = "RefScenario2";
    private static final FullQualifiedName ENTITY_TYPE_1_1 = new FullQualifiedName("RefScenario", "Employee");
    private static final FullQualifiedName ENTITY_TYPE_1_BASE = new FullQualifiedName("RefScenario", "Base");
    private static final FullQualifiedName ENTITY_TYPE_1_2 = new FullQualifiedName("RefScenario", "Team");
    private static final FullQualifiedName ENTITY_TYPE_1_3 = new FullQualifiedName("RefScenario", "Room");
    private static final FullQualifiedName ENTITY_TYPE_1_4 = new FullQualifiedName("RefScenario", "Manager");
    private static final FullQualifiedName ENTITY_TYPE_1_5 = new FullQualifiedName("RefScenario", "Building");
    private static final FullQualifiedName ENTITY_TYPE_2_1 = new FullQualifiedName("RefScenario2", "Photo");
    private static final FullQualifiedName COMPLEX_TYPE_1 = new FullQualifiedName("RefScenario", "c_Location");
    private static final FullQualifiedName COMPLEX_TYPE_2 = new FullQualifiedName("RefScenario", "c_City");
    private static final FullQualifiedName ASSOCIATION_1_1 = new FullQualifiedName("RefScenario", "ManagerEmployees");
    private static final FullQualifiedName ASSOCIATION_1_2 = new FullQualifiedName("RefScenario", "TeamEmployees");
    private static final FullQualifiedName ASSOCIATION_1_3 = new FullQualifiedName("RefScenario", "RoomEmployees");
    private static final FullQualifiedName ASSOCIATION_1_4 = new FullQualifiedName("RefScenario", "BuildingRooms");
    private static final String ROLE_1_1 = "r_Employees";
    private static final String ROLE_1_2 = "r_Team";
    private static final String ROLE_1_3 = "r_Room";
    private static final String ROLE_1_4 = "r_Manager";
    private static final String ROLE_1_5 = "r_Building";
    private static final String ENTITY_CONTAINER_1 = "Container1";
    private static final String ENTITY_CONTAINER_2 = "Container2";
    private static final String ENTITY_SET_1_1 = "Employees";
    private static final String ENTITY_SET_1_2 = "Teams";
    private static final String ENTITY_SET_1_3 = "Rooms";
    private static final String ENTITY_SET_1_4 = "Managers";
    private static final String ENTITY_SET_1_5 = "Buildings";
    private static final String ENTITY_SET_2_1 = "Photos";
    private static final String FUNCTION_IMPORT_1 = "EmployeeSearch";
    private static final String FUNCTION_IMPORT_2 = "AllLocations";
    private static final String FUNCTION_IMPORT_3 = "AllUsedRoomIds";
    private static final String FUNCTION_IMPORT_4 = "MaximalAge";
    private static final String FUNCTION_IMPORT_5 = "MostCommonLocation";
    private static final String FUNCTION_IMPORT_6 = "ManagerPhoto";
    private static final String FUNCTION_IMPORT_7 = "OldestEmployee";
    private static final String ACTION_IMPORT_1 = "AddEmployee";

    public List<Schema> getSchemas() throws ODataException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        Schema schema = new Schema();
        schema.setNamespace(NAMESPACE_1);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_1));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_2));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_3));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_4));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_5));
        entityTypes.add(this.getEntityType(ENTITY_TYPE_1_BASE));
        schema.setEntityTypes(entityTypes);
        ArrayList<ComplexType> complexTypes = new ArrayList<ComplexType>();
        complexTypes.add(this.getComplexType(COMPLEX_TYPE_1));
        complexTypes.add(this.getComplexType(COMPLEX_TYPE_2));
        schema.setComplexTypes(complexTypes);
        ArrayList<Association> associations = new ArrayList<Association>();
        associations.add(this.getAssociation(ASSOCIATION_1_1));
        associations.add(this.getAssociation(ASSOCIATION_1_2));
        associations.add(this.getAssociation(ASSOCIATION_1_3));
        associations.add(this.getAssociation(ASSOCIATION_1_4));
        schema.setAssociations(associations);
        EntityContainer entityContainer = new EntityContainer();
        entityContainer.setName(ENTITY_CONTAINER_1).setDefaultEntityContainer(true);
        ArrayList<EntitySet> entitySets = new ArrayList<EntitySet>();
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER_1, ENTITY_SET_1_1));
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER_1, ENTITY_SET_1_2));
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER_1, ENTITY_SET_1_3));
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER_1, ENTITY_SET_1_4));
        entitySets.add(this.getEntitySet(ENTITY_CONTAINER_1, ENTITY_SET_1_5));
        entityContainer.setEntitySets(entitySets);
        ArrayList<AssociationSet> associationSets = new ArrayList<AssociationSet>();
        associationSets.add(this.getAssociationSet(ENTITY_CONTAINER_1, ASSOCIATION_1_1, ENTITY_SET_1_4, ROLE_1_4));
        associationSets.add(this.getAssociationSet(ENTITY_CONTAINER_1, ASSOCIATION_1_2, ENTITY_SET_1_2, ROLE_1_2));
        associationSets.add(this.getAssociationSet(ENTITY_CONTAINER_1, ASSOCIATION_1_3, ENTITY_SET_1_3, ROLE_1_3));
        associationSets.add(this.getAssociationSet(ENTITY_CONTAINER_1, ASSOCIATION_1_4, ENTITY_SET_1_5, ROLE_1_5));
        entityContainer.setAssociationSets(associationSets);
        ArrayList<FunctionImport> functionImports = new ArrayList<FunctionImport>();
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_1));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_2));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_3));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_4));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_5));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_6));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, FUNCTION_IMPORT_7));
        functionImports.add(this.getFunctionImport(ENTITY_CONTAINER_1, ACTION_IMPORT_1));
        entityContainer.setFunctionImports(functionImports);
        schema.setEntityContainers(Arrays.asList(entityContainer));
        schemas.add(schema);
        schema = new Schema();
        schema.setNamespace(NAMESPACE_2);
        schema.setEntityTypes(Arrays.asList(this.getEntityType(ENTITY_TYPE_2_1)));
        entityContainer = new EntityContainer();
        entityContainer.setName(ENTITY_CONTAINER_2);
        entityContainer.setEntitySets(Arrays.asList(this.getEntitySet(ENTITY_CONTAINER_2, ENTITY_SET_2_1)));
        schema.setEntityContainers(Arrays.asList(entityContainer));
        schemas.add(schema);
        return schemas;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE_1.equals(edmFQName.getNamespace())) {
            if (ENTITY_TYPE_1_1.getName().equals(edmFQName.getName())) {
                ArrayList<Object> properties = new ArrayList<Object>();
                properties.add(new SimpleProperty().setName("EmployeeId").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))).setMapping(new Mapping().setInternalName("getId")));
                properties.add(new SimpleProperty().setName("EmployeeName").setType(EdmSimpleTypeKind.String).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationTitle")));
                properties.add(new SimpleProperty().setName("ManagerId").setType(EdmSimpleTypeKind.String).setMapping(new Mapping().setInternalName("getManager.getId")));
                properties.add(new SimpleProperty().setName("RoomId").setType(EdmSimpleTypeKind.String).setMapping(new Mapping().setInternalName("getRoom.getId")));
                properties.add(new SimpleProperty().setName("TeamId").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setMaxLength(Integer.valueOf(2))).setMapping(new Mapping().setInternalName("getTeam.getId")));
                properties.add(new ComplexProperty().setName("Location").setType(COMPLEX_TYPE_1).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
                properties.add(new SimpleProperty().setName("Age").setType(EdmSimpleTypeKind.Int16));
                properties.add(new SimpleProperty().setName("EntryDate").setType(EdmSimpleTypeKind.DateTime).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(true))).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationUpdated")));
                properties.add(new SimpleProperty().setName("ImageUrl").setType(EdmSimpleTypeKind.String).setMapping(new Mapping().setInternalName("getImageUri")));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName("ne_Manager").setRelationship(ASSOCIATION_1_1).setFromRole(ROLE_1_1).setToRole(ROLE_1_4));
                navigationProperties.add(new NavigationProperty().setName("ne_Team").setRelationship(ASSOCIATION_1_2).setFromRole(ROLE_1_1).setToRole(ROLE_1_2));
                navigationProperties.add(new NavigationProperty().setName("ne_Room").setRelationship(ASSOCIATION_1_3).setFromRole(ROLE_1_1).setToRole(ROLE_1_3));
                return new EntityType().setName(ENTITY_TYPE_1_1.getName()).setProperties(properties).setHasStream(true).setKey(this.getKey("EmployeeId")).setNavigationProperties(navigationProperties).setMapping(new Mapping().setMediaResourceMimeTypeKey("getImageType"));
            }
            if (ENTITY_TYPE_1_BASE.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("Id").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setDefaultValue("1")));
                properties.add(new SimpleProperty().setName("Name").setType(EdmSimpleTypeKind.String).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationTitle")));
                return new EntityType().setName(ENTITY_TYPE_1_BASE.getName()).setAbstract(true).setProperties(properties).setKey(this.getKey("Id"));
            }
            if (ENTITY_TYPE_1_2.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("isScrumTeam").setType(EdmSimpleTypeKind.Boolean).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(true))).setMapping(new Mapping().setInternalName("isScrumTeam")));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName("nt_Employees").setRelationship(ASSOCIATION_1_2).setFromRole(ROLE_1_2).setToRole(ROLE_1_1));
                return new EntityType().setName(ENTITY_TYPE_1_2.getName()).setBaseType(ENTITY_TYPE_1_BASE).setProperties(properties).setNavigationProperties(navigationProperties);
            }
            if (ENTITY_TYPE_1_3.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("Seats").setType(EdmSimpleTypeKind.Int16));
                properties.add(new SimpleProperty().setName("Version").setType(EdmSimpleTypeKind.Int16).setFacets((EdmFacets)new Facets().setConcurrencyMode(EdmConcurrencyMode.Fixed)));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName("nr_Employees").setRelationship(ASSOCIATION_1_3).setFromRole(ROLE_1_3).setToRole(ROLE_1_1));
                navigationProperties.add(new NavigationProperty().setName("nr_Building").setRelationship(ASSOCIATION_1_4).setFromRole(ROLE_1_3).setToRole(ROLE_1_5));
                return new EntityType().setName(ENTITY_TYPE_1_3.getName()).setBaseType(ENTITY_TYPE_1_BASE).setProperties(properties).setNavigationProperties(navigationProperties);
            }
            if (ENTITY_TYPE_1_4.getName().equals(edmFQName.getName())) {
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName("nm_Employees").setRelationship(ASSOCIATION_1_1).setFromRole(ROLE_1_4).setToRole(ROLE_1_1));
                return new EntityType().setName(ENTITY_TYPE_1_4.getName()).setBaseType(ENTITY_TYPE_1_1).setHasStream(true).setNavigationProperties(navigationProperties).setMapping(new Mapping().setMediaResourceMimeTypeKey("getImageType"));
            }
            if (ENTITY_TYPE_1_5.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("Id").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
                properties.add(new SimpleProperty().setName("Name").setType(EdmSimpleTypeKind.String).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationAuthorName")));
                properties.add(new SimpleProperty().setName("Image").setType(EdmSimpleTypeKind.Binary));
                ArrayList<NavigationProperty> navigationProperties = new ArrayList<NavigationProperty>();
                navigationProperties.add(new NavigationProperty().setName("nb_Rooms").setRelationship(ASSOCIATION_1_4).setFromRole(ROLE_1_5).setToRole(ROLE_1_3));
                return new EntityType().setName(ENTITY_TYPE_1_5.getName()).setProperties(properties).setKey(this.getKey("Id")).setNavigationProperties(navigationProperties);
            }
        } else if (NAMESPACE_2.equals(edmFQName.getNamespace()) && ENTITY_TYPE_2_1.getName().equals(edmFQName.getName())) {
            ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
            properties.add(new SimpleProperty().setName("Id").setType(EdmSimpleTypeKind.Int32).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)).setConcurrencyMode(EdmConcurrencyMode.Fixed)));
            properties.add(new SimpleProperty().setName("Name").setType(EdmSimpleTypeKind.String).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationTitle")));
            properties.add(new SimpleProperty().setName("Type").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
            properties.add(new SimpleProperty().setName("ImageUrl").setType(EdmSimpleTypeKind.String).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcTargetPath("SyndicationAuthorUri")).setMapping(new Mapping().setInternalName("getImageUri")));
            properties.add(new SimpleProperty().setName("Image").setType(EdmSimpleTypeKind.Binary).setMapping(new Mapping().setMediaResourceMimeTypeKey("getImageType")));
            properties.add(new SimpleProperty().setName("BinaryData").setType(EdmSimpleTypeKind.Binary).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(true))).setMimeType("image/jpeg"));
            properties.add(new SimpleProperty().setName("\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(true))).setCustomizableFeedMappings(new CustomizableFeedMappings().setFcKeepInContent(Boolean.valueOf(false)).setFcNsPrefix("\u0440\u0443").setFcNsUri("http://localhost").setFcTargetPath("\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435")).setMapping(new Mapping().setInternalName("getContent")));
            return new EntityType().setName(ENTITY_TYPE_2_1.getName()).setProperties(properties).setHasStream(true).setKey(this.getKey("Id", "Type")).setMapping(new Mapping().setMediaResourceMimeTypeKey("getType"));
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE_1.equals(edmFQName.getNamespace())) {
            if (COMPLEX_TYPE_1.getName().equals(edmFQName.getName())) {
                ArrayList<Object> properties = new ArrayList<Object>();
                properties.add(new ComplexProperty().setName("City").setType(COMPLEX_TYPE_2).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false))));
                properties.add(new SimpleProperty().setName("Country").setType(EdmSimpleTypeKind.String));
                return new ComplexType().setName(COMPLEX_TYPE_1.getName()).setProperties(properties);
            }
            if (COMPLEX_TYPE_2.getName().equals(edmFQName.getName())) {
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                properties.add(new SimpleProperty().setName("PostalCode").setType(EdmSimpleTypeKind.String));
                properties.add(new SimpleProperty().setName("CityName").setType(EdmSimpleTypeKind.String));
                return new ComplexType().setName(COMPLEX_TYPE_2.getName()).setProperties(properties);
            }
        }
        return null;
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        if (NAMESPACE_1.equals(edmFQName.getNamespace())) {
            if (ASSOCIATION_1_1.getName().equals(edmFQName.getName())) {
                return new Association().setName(ASSOCIATION_1_1.getName()).setEnd1(new AssociationEnd().setType(ENTITY_TYPE_1_1).setRole(ROLE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setEnd2(new AssociationEnd().setType(ENTITY_TYPE_1_4).setRole(ROLE_1_4).setMultiplicity(EdmMultiplicity.ONE));
            }
            if (ASSOCIATION_1_2.getName().equals(edmFQName.getName())) {
                return new Association().setName(ASSOCIATION_1_2.getName()).setEnd1(new AssociationEnd().setType(ENTITY_TYPE_1_1).setRole(ROLE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setEnd2(new AssociationEnd().setType(ENTITY_TYPE_1_2).setRole(ROLE_1_2).setMultiplicity(EdmMultiplicity.ONE).setOnDelete(new OnDelete().setAction(EdmAction.None)));
            }
            if (ASSOCIATION_1_3.getName().equals(edmFQName.getName())) {
                return new Association().setName(ASSOCIATION_1_3.getName()).setEnd1(new AssociationEnd().setType(ENTITY_TYPE_1_1).setRole(ROLE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setEnd2(new AssociationEnd().setType(ENTITY_TYPE_1_3).setRole(ROLE_1_3).setMultiplicity(EdmMultiplicity.ONE));
            }
            if (ASSOCIATION_1_4.getName().equals(edmFQName.getName())) {
                return new Association().setName(ASSOCIATION_1_4.getName()).setEnd1(new AssociationEnd().setType(ENTITY_TYPE_1_5).setRole(ROLE_1_5).setMultiplicity(EdmMultiplicity.ONE)).setEnd2(new AssociationEnd().setType(ENTITY_TYPE_1_3).setRole(ROLE_1_3).setMultiplicity(EdmMultiplicity.MANY));
            }
        }
        return null;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        if (name == null || ENTITY_CONTAINER_1.equals(name)) {
            return new EntityContainerInfo().setName(ENTITY_CONTAINER_1).setDefaultEntityContainer(true);
        }
        if (ENTITY_CONTAINER_2.equals(name)) {
            return new EntityContainerInfo().setName(name).setDefaultEntityContainer(false);
        }
        return null;
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        if (ENTITY_CONTAINER_1.equals(entityContainer)) {
            if (ENTITY_SET_1_1.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_1);
            }
            if (ENTITY_SET_1_2.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_2);
            }
            if (ENTITY_SET_1_3.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_3);
            }
            if (ENTITY_SET_1_4.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_4);
            }
            if (ENTITY_SET_1_5.equals(name)) {
                return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_1_5);
            }
        } else if (ENTITY_CONTAINER_2.equals(entityContainer) && ENTITY_SET_2_1.equals(name)) {
            return new EntitySet().setName(name).setEntityType(ENTITY_TYPE_2_1);
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        if (ENTITY_CONTAINER_1.equals(entityContainer)) {
            if (FUNCTION_IMPORT_1.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(ENTITY_TYPE_1_1).setMultiplicity(EdmMultiplicity.MANY)).setEntitySet(ENTITY_SET_1_1).setHttpMethod("GET").setParameters(Arrays.asList(new FunctionImportParameter().setName("q").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(true)))));
            }
            if (FUNCTION_IMPORT_2.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(COMPLEX_TYPE_1).setMultiplicity(EdmMultiplicity.MANY)).setHttpMethod("GET");
            }
            if (FUNCTION_IMPORT_3.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(EdmSimpleTypeKind.String.getFullQualifiedName()).setMultiplicity(EdmMultiplicity.MANY)).setHttpMethod("GET");
            }
            if (FUNCTION_IMPORT_4.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(EdmSimpleTypeKind.Int16.getFullQualifiedName()).setMultiplicity(EdmMultiplicity.ONE)).setHttpMethod("GET");
            }
            if (FUNCTION_IMPORT_5.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(COMPLEX_TYPE_1).setMultiplicity(EdmMultiplicity.ONE)).setHttpMethod("GET");
            }
            if (FUNCTION_IMPORT_6.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(EdmSimpleTypeKind.Binary.getFullQualifiedName()).setMultiplicity(EdmMultiplicity.ONE)).setHttpMethod("GET").setParameters(Arrays.asList(new FunctionImportParameter().setName("Id").setType(EdmSimpleTypeKind.String).setFacets((EdmFacets)new Facets().setNullable(Boolean.valueOf(false)))));
            }
            if (FUNCTION_IMPORT_7.equals(name)) {
                return new FunctionImport().setName(name).setReturnType(new ReturnType().setTypeName(ENTITY_TYPE_1_1).setMultiplicity(EdmMultiplicity.ZERO_TO_ONE)).setEntitySet(ENTITY_SET_1_1).setHttpMethod("GET");
            }
            if (ACTION_IMPORT_1.equals(name)) {
                return new FunctionImport().setName(name).setEntitySet(ENTITY_SET_1_1).setHttpMethod("POST");
            }
        }
        return null;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        if (ENTITY_CONTAINER_1.equals(entityContainer)) {
            if (ASSOCIATION_1_1.equals((Object)association)) {
                return new AssociationSet().setName(ASSOCIATION_1_1.getName()).setAssociation(ASSOCIATION_1_1).setEnd1(new AssociationSetEnd().setRole(ROLE_1_4).setEntitySet(ENTITY_SET_1_4)).setEnd2(new AssociationSetEnd().setRole(ROLE_1_1).setEntitySet(ENTITY_SET_1_1));
            }
            if (ASSOCIATION_1_2.equals((Object)association)) {
                return new AssociationSet().setName(ASSOCIATION_1_2.getName()).setAssociation(ASSOCIATION_1_2).setEnd1(new AssociationSetEnd().setRole(ROLE_1_2).setEntitySet(ENTITY_SET_1_2)).setEnd2(new AssociationSetEnd().setRole(ROLE_1_1).setEntitySet(ENTITY_SET_1_1));
            }
            if (ASSOCIATION_1_3.equals((Object)association)) {
                return new AssociationSet().setName(ASSOCIATION_1_3.getName()).setAssociation(ASSOCIATION_1_3).setEnd1(new AssociationSetEnd().setRole(ROLE_1_3).setEntitySet(ENTITY_SET_1_3)).setEnd2(new AssociationSetEnd().setRole(ROLE_1_1).setEntitySet(ENTITY_SET_1_1));
            }
            if (ASSOCIATION_1_4.equals((Object)association)) {
                return new AssociationSet().setName(ASSOCIATION_1_4.getName()).setAssociation(ASSOCIATION_1_4).setEnd1(new AssociationSetEnd().setRole(ROLE_1_5).setEntitySet(ENTITY_SET_1_5)).setEnd2(new AssociationSetEnd().setRole(ROLE_1_3).setEntitySet(ENTITY_SET_1_3));
            }
        }
        return null;
    }

    private Key getKey(String ... keyNames) {
        ArrayList<PropertyRef> keyProperties = new ArrayList<PropertyRef>();
        for (String keyName : keyNames) {
            keyProperties.add(new PropertyRef().setName(keyName));
        }
        return new Key().setKeys(keyProperties);
    }
}

