/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.ref.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.ref.model.Building;
import org.apache.olingo.odata2.ref.model.DataContainer;
import org.apache.olingo.odata2.ref.model.Employee;
import org.apache.olingo.odata2.ref.model.Location;
import org.apache.olingo.odata2.ref.model.Manager;
import org.apache.olingo.odata2.ref.model.Photo;
import org.apache.olingo.odata2.ref.model.Room;
import org.apache.olingo.odata2.ref.model.Team;
import org.apache.olingo.odata2.ref.processor.Util;

public class ScenarioDataSource {
    private static final String ENTITYSET_1_1 = "Employees";
    private static final String ENTITYSET_1_2 = "Teams";
    private static final String ENTITYSET_1_3 = "Rooms";
    private static final String ENTITYSET_1_4 = "Managers";
    private static final String ENTITYSET_1_5 = "Buildings";
    private static final String ENTITYSET_2_1 = "Photos";
    private final DataContainer dataContainer;

    public ScenarioDataSource(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public List<?> readData(EdmEntitySet entitySet) throws ODataNotImplementedException, ODataNotFoundException, EdmException {
        if (ENTITYSET_1_1.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getEmployees().toArray());
        }
        if (ENTITYSET_1_2.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getTeams().toArray());
        }
        if (ENTITYSET_1_3.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getRooms().toArray());
        }
        if (ENTITYSET_1_4.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getManagers().toArray());
        }
        if (ENTITYSET_1_5.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getBuildings().toArray());
        }
        if (ENTITYSET_2_1.equals(entitySet.getName())) {
            return Arrays.asList(this.dataContainer.getPhotos().toArray());
        }
        throw new ODataNotImplementedException();
    }

    public Object readData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException {
        if (ENTITYSET_1_1.equals(entitySet.getName())) {
            for (Employee employee : this.dataContainer.getEmployees()) {
                if (!employee.getId().equals(keys.get("EmployeeId"))) continue;
                return employee;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_1_2.equals(entitySet.getName())) {
            for (Team team : this.dataContainer.getTeams()) {
                if (!team.getId().equals(keys.get("Id"))) continue;
                return team;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_1_3.equals(entitySet.getName())) {
            for (Room room : this.dataContainer.getRooms()) {
                if (!room.getId().equals(keys.get("Id"))) continue;
                return room;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_1_4.equals(entitySet.getName())) {
            for (Manager manager : this.dataContainer.getManagers()) {
                if (!manager.getId().equals(keys.get("EmployeeId"))) continue;
                return manager;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_1_5.equals(entitySet.getName())) {
            for (Building building : this.dataContainer.getBuildings()) {
                if (!building.getId().equals(keys.get("Id"))) continue;
                return building;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_2_1.equals(entitySet.getName())) {
            for (Photo photo : this.dataContainer.getPhotos()) {
                if (photo.getId() != ((Integer)keys.get("Id")).intValue() || !photo.getType().equals(keys.get("Type"))) continue;
                return photo;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        throw new ODataNotImplementedException();
    }

    public Object readRelatedData(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException {
        if (ENTITYSET_1_1.equals(targetEntitySet.getName())) {
            List<Object> data = Collections.emptyList();
            if (ENTITYSET_1_2.equals(sourceEntitySet.getName())) {
                data = ((Team)sourceData).getEmployees();
            } else if (ENTITYSET_1_3.equals(sourceEntitySet.getName())) {
                data = ((Room)sourceData).getEmployees();
            } else if (ENTITYSET_1_4.equals(sourceEntitySet.getName())) {
                data = ((Manager)sourceData).getEmployees();
            }
            if (data.isEmpty()) {
                throw new ODataNotFoundException(null);
            }
            if (targetKeys.isEmpty()) {
                return Arrays.asList(data.toArray());
            }
            for (Object employee : data) {
                if (!((Employee)employee).getId().equals(targetKeys.get("EmployeeId"))) continue;
                return employee;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (ENTITYSET_1_2.equals(targetEntitySet.getName())) {
            if (((Employee)sourceData).getTeam() == null) {
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            return ((Employee)sourceData).getTeam();
        }
        if (ENTITYSET_1_3.equals(targetEntitySet.getName())) {
            if (ENTITYSET_1_1.equals(sourceEntitySet.getName())) {
                if (((Employee)sourceData).getRoom() == null) {
                    throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
                }
                return ((Employee)sourceData).getRoom();
            }
            if (ENTITYSET_1_5.equals(sourceEntitySet.getName())) {
                List<Room> data = ((Building)sourceData).getRooms();
                if (data.isEmpty()) {
                    throw new ODataNotFoundException(null);
                }
                if (targetKeys.isEmpty()) {
                    return Arrays.asList(data.toArray());
                }
                for (Room room : data) {
                    if (!room.getId().equals(targetKeys.get("Id"))) continue;
                    return room;
                }
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            throw new ODataNotImplementedException();
        }
        if (ENTITYSET_1_4.equals(targetEntitySet.getName())) {
            if (((Employee)sourceData).getManager() == null) {
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            return ((Employee)sourceData).getManager();
        }
        if (ENTITYSET_1_5.equals(targetEntitySet.getName())) {
            if (((Room)sourceData).getBuilding() == null) {
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            return ((Room)sourceData).getBuilding();
        }
        throw new ODataNotImplementedException();
    }

    public Object readData(EdmFunctionImport function, Map<String, Object> parameters, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException {
        if (function.getName().equals("EmployeeSearch")) {
            if (parameters.get("q") == null) {
                throw new ODataNotFoundException(null);
            }
            List<Employee> found = this.searchEmployees((String)parameters.get("q"));
            if (null == keys || keys.isEmpty()) {
                return found;
            }
            for (Employee employee : found) {
                if (!employee.getId().equals(keys.get("EmployeeId"))) continue;
                return employee;
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (function.getName().equals("AllLocations")) {
            return Arrays.asList(this.getLocations().keySet().toArray());
        }
        if (function.getName().equals("AllUsedRoomIds")) {
            ArrayList<String> data = new ArrayList<String>();
            for (Room room : this.dataContainer.getRooms()) {
                if (room.getEmployees().isEmpty()) continue;
                data.add(room.getId());
            }
            if (data.isEmpty()) {
                throw new ODataNotFoundException(null);
            }
            return data;
        }
        if (function.getName().equals("MaximalAge")) {
            return this.getOldestEmployee().getAge();
        }
        if (function.getName().equals("MostCommonLocation")) {
            return this.getMostCommonLocation();
        }
        if (function.getName().equals("ManagerPhoto")) {
            if (parameters.get("Id") == null) {
                throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
            }
            for (Manager manager : this.dataContainer.getManagers()) {
                if (!manager.getId().equals(parameters.get("Id"))) continue;
                return new BinaryData(manager.getImage(), manager.getImageType());
            }
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        if (function.getName().equals("AddEmployee")) {
            return null;
        }
        if (function.getName().equals("OldestEmployee")) {
            return this.getOldestEmployee();
        }
        throw new ODataNotImplementedException();
    }

    private List<Employee> searchEmployees(String search) {
        ArrayList<Employee> employees = new ArrayList<Employee>();
        for (Employee employee : this.dataContainer.getEmployees()) {
            if (!employee.getEmployeeName().contains(search) && (employee.getLocation() == null || !employee.getLocation().getCity().getCityName().contains(search) && !employee.getLocation().getCity().getPostalCode().contains(search) && !employee.getLocation().getCountry().contains(search))) continue;
            employees.add(employee);
        }
        return employees;
    }

    private Map<Location, Integer> getLocations() throws ODataNotFoundException {
        LinkedHashMap<Location, Integer> locations = new LinkedHashMap<Location, Integer>();
        for (Employee employee : this.dataContainer.getEmployees()) {
            if (employee.getLocation() == null || employee.getLocation().getCity() == null) continue;
            boolean found = false;
            for (Location location : locations.keySet()) {
                if (employee.getLocation().getCity().getPostalCode() != location.getCity().getPostalCode() || employee.getLocation().getCity().getCityName() != location.getCity().getCityName() || employee.getLocation().getCountry() != location.getCountry()) continue;
                found = true;
                locations.put(location, (Integer)locations.get(location) + 1);
            }
            if (found) continue;
            locations.put(employee.getLocation(), 1);
        }
        if (locations.isEmpty()) {
            throw new ODataNotFoundException(null);
        }
        return locations;
    }

    private Location getMostCommonLocation() throws ODataNotFoundException {
        Integer count = 0;
        Location location = null;
        for (Map.Entry<Location, Integer> entry : this.getLocations().entrySet()) {
            if (entry.getValue() <= count) continue;
            count = entry.getValue();
            location = entry.getKey();
        }
        return location;
    }

    private Employee getOldestEmployee() {
        Employee oldestEmployee = null;
        for (Employee employee : this.dataContainer.getEmployees()) {
            if (oldestEmployee != null && employee.getAge() <= oldestEmployee.getAge()) continue;
            oldestEmployee = employee;
        }
        return oldestEmployee;
    }

    public BinaryData readBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        if (mediaLinkEntryData == null) {
            throw new ODataNotFoundException(null);
        }
        if (ENTITYSET_1_1.equals(entitySet.getName()) || ENTITYSET_1_4.equals(entitySet.getName())) {
            Employee employee = (Employee)mediaLinkEntryData;
            if (employee.getImage() == null) {
                throw new ODataNotFoundException(null);
            }
            return new BinaryData(employee.getImage(), employee.getImageType());
        }
        if (ENTITYSET_2_1.equals(entitySet.getName())) {
            Photo photo = (Photo)mediaLinkEntryData;
            return new BinaryData(photo.getImage(), photo.getImageType());
        }
        throw new ODataNotImplementedException();
    }

    public void writeBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData, BinaryData binaryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        if (mediaLinkEntryData == null) {
            throw new ODataNotFoundException(null);
        }
        if (ENTITYSET_1_1.equals(entitySet.getName()) || ENTITYSET_1_4.equals(entitySet.getName())) {
            Employee employee = (Employee)mediaLinkEntryData;
            employee.setImage(binaryData.getData());
            employee.setImageType(binaryData.getMimeType());
            Util.getInstance().setBinaryContent(employee.getImage());
        } else if (ENTITYSET_2_1.equals(entitySet.getName())) {
            Photo photo = (Photo)mediaLinkEntryData;
            photo.setImage(binaryData.getData());
            photo.setImageType(binaryData.getMimeType());
        } else {
            throw new ODataNotImplementedException();
        }
    }

    public Object newDataObject(EdmEntitySet entitySet) throws ODataNotImplementedException, EdmException {
        if (ENTITYSET_1_1.equals(entitySet.getName())) {
            Employee employee = this.dataContainer.createEmployee();
            employee.setAge(0);
            employee.setLocation(new Location(null, null, null));
            return employee;
        }
        if (ENTITYSET_1_2.equals(entitySet.getName())) {
            return this.dataContainer.createTeam();
        }
        if (ENTITYSET_1_3.equals(entitySet.getName())) {
            Room room = this.dataContainer.createRoom();
            room.setSeats(0);
            room.setVersion(0);
            return room;
        }
        if (ENTITYSET_1_4.equals(entitySet.getName())) {
            Manager manager = this.dataContainer.createManager();
            manager.setAge(0);
            manager.setLocation(new Location(null, null, null));
            return manager;
        }
        if (ENTITYSET_1_5.equals(entitySet.getName())) {
            return this.dataContainer.createBuilding();
        }
        if (ENTITYSET_2_1.equals(entitySet.getName())) {
            return this.dataContainer.createPhoto("application/octet-stream");
        }
        throw new ODataNotImplementedException();
    }

    public void deleteData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        Object data = this.readData(entitySet, keys);
        if (ENTITYSET_1_1.equals(entitySet.getName()) || ENTITYSET_1_4.equals(entitySet.getName())) {
            Employee employee;
            if (data instanceof Manager) {
                for (Employee employee2 : ((Manager)data).getEmployees()) {
                    employee2.setManager(null);
                }
            }
            if ((employee = (Employee)data).getManager() != null) {
                employee.getManager().getEmployees().remove(employee);
            }
            if (employee.getTeam() != null) {
                employee.getTeam().getEmployees().remove(employee);
            }
            if (employee.getRoom() != null) {
                employee.getRoom().getEmployees().remove(employee);
            }
            if (data instanceof Manager) {
                this.dataContainer.getManagers().remove(data);
            }
            this.dataContainer.getEmployees().remove(data);
        } else if (ENTITYSET_1_2.equals(entitySet.getName())) {
            for (Employee employee : ((Team)data).getEmployees()) {
                employee.setTeam(null);
            }
            this.dataContainer.getTeams().remove(data);
        } else if (ENTITYSET_1_3.equals(entitySet.getName())) {
            for (Employee employee : ((Room)data).getEmployees()) {
                employee.setRoom(null);
            }
            if (((Room)data).getBuilding() != null) {
                ((Room)data).getBuilding().getRooms().remove(data);
            }
            this.dataContainer.getRooms().remove(data);
        } else if (ENTITYSET_1_5.equals(entitySet.getName())) {
            for (Room room : ((Building)data).getRooms()) {
                room.setBuilding(null);
            }
            this.dataContainer.getBuildings().remove(data);
        } else if (ENTITYSET_2_1.equals(entitySet.getName())) {
            this.dataContainer.getPhotos().remove(data);
        } else {
            throw new ODataNotImplementedException();
        }
    }

    public void createData(EdmEntitySet entitySet, Object data) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        if (ENTITYSET_1_1.equals(entitySet.getName())) {
            this.dataContainer.getEmployees().add((Employee)data);
        } else if (ENTITYSET_1_2.equals(entitySet.getName())) {
            this.dataContainer.getTeams().add((Team)data);
        } else if (ENTITYSET_1_3.equals(entitySet.getName())) {
            this.dataContainer.getRooms().add((Room)data);
        } else if (ENTITYSET_1_4.equals(entitySet.getName())) {
            this.dataContainer.getManagers().add((Manager)data);
        } else if (ENTITYSET_1_5.equals(entitySet.getName())) {
            this.dataContainer.getBuildings().add((Building)data);
        } else if (ENTITYSET_2_1.equals(entitySet.getName())) {
            this.dataContainer.getPhotos().add((Photo)data);
        } else {
            throw new ODataNotImplementedException();
        }
    }

    public void deleteRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        if (ENTITYSET_1_1.equals(targetEntitySet.getName())) {
            if (ENTITYSET_1_2.equals(sourceEntitySet.getName())) {
                Iterator<Employee> iterator = ((Team)sourceData).getEmployees().iterator();
                while (iterator.hasNext()) {
                    Employee employee = iterator.next();
                    if (!employee.getId().equals(targetKeys.get("EmployeeId"))) continue;
                    employee.setTeam(null);
                    iterator.remove();
                }
            } else if (ENTITYSET_1_3.equals(sourceEntitySet.getName())) {
                Iterator<Employee> iterator = ((Room)sourceData).getEmployees().iterator();
                while (iterator.hasNext()) {
                    Employee employee = iterator.next();
                    if (!employee.getId().equals(targetKeys.get("EmployeeId"))) continue;
                    employee.setRoom(null);
                    iterator.remove();
                }
            } else if (ENTITYSET_1_4.equals(sourceEntitySet.getName())) {
                Iterator<Employee> iterator = ((Manager)sourceData).getEmployees().iterator();
                while (iterator.hasNext()) {
                    Employee employee = iterator.next();
                    if (!employee.getId().equals(targetKeys.get("EmployeeId"))) continue;
                    employee.setManager(null);
                    iterator.remove();
                }
            }
        } else if (ENTITYSET_1_2.equals(targetEntitySet.getName())) {
            ((Employee)sourceData).getTeam().getEmployees().remove(sourceData);
            ((Employee)sourceData).setTeam(null);
        } else if (ENTITYSET_1_3.equals(targetEntitySet.getName())) {
            if (ENTITYSET_1_1.equals(sourceEntitySet.getName())) {
                ((Employee)sourceData).getRoom().getEmployees().remove(sourceData);
                ((Employee)sourceData).setRoom(null);
            } else if (ENTITYSET_1_5.equals(sourceEntitySet.getName())) {
                Iterator<Room> iterator = ((Building)sourceData).getRooms().iterator();
                while (iterator.hasNext()) {
                    Room room = iterator.next();
                    if (!room.getId().equals(targetKeys.get("Id"))) continue;
                    room.setBuilding(null);
                    iterator.remove();
                }
            }
        } else if (ENTITYSET_1_4.equals(targetEntitySet.getName())) {
            ((Employee)sourceData).getManager().getEmployees().remove(sourceData);
            ((Employee)sourceData).setManager(null);
        } else if (ENTITYSET_1_5.equals(targetEntitySet.getName())) {
            ((Room)sourceData).getBuilding().getRooms().remove(sourceData);
            ((Room)sourceData).setBuilding(null);
        } else {
            throw new ODataNotImplementedException();
        }
    }

    public void writeRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        if (ENTITYSET_1_1.equals(targetEntitySet.getName())) {
            Employee employee = (Employee)this.readData(targetEntitySet, targetKeys);
            if (ENTITYSET_1_2.equals(sourceEntitySet.getName())) {
                if (employee.getTeam() != null) {
                    employee.getTeam().getEmployees().remove(employee);
                }
                employee.setTeam((Team)sourceData);
                ((Team)sourceData).getEmployees().add(employee);
            } else if (ENTITYSET_1_3.equals(sourceEntitySet.getName())) {
                if (employee.getRoom() != null) {
                    employee.getRoom().getEmployees().remove(employee);
                }
                employee.setRoom((Room)sourceData);
                ((Room)sourceData).getEmployees().add(employee);
            } else if (ENTITYSET_1_4.equals(sourceEntitySet.getName())) {
                if (employee.getManager() != null) {
                    employee.getManager().getEmployees().remove(employee);
                }
                employee.setManager((Manager)sourceData);
                ((Manager)sourceData).getEmployees().add(employee);
            }
        } else if (ENTITYSET_1_2.equals(targetEntitySet.getName())) {
            Team team = (Team)this.readData(targetEntitySet, targetKeys);
            if (((Employee)sourceData).getTeam() != null) {
                ((Employee)sourceData).getTeam().getEmployees().remove(sourceData);
            }
            ((Employee)sourceData).setTeam(team);
            team.getEmployees().add((Employee)sourceData);
        } else if (ENTITYSET_1_3.equals(targetEntitySet.getName())) {
            Room room = (Room)this.readData(targetEntitySet, targetKeys);
            if (ENTITYSET_1_1.equals(sourceEntitySet.getName())) {
                if (((Employee)sourceData).getRoom() != null) {
                    ((Employee)sourceData).getRoom().getEmployees().remove(sourceData);
                }
                ((Employee)sourceData).setRoom(room);
                room.getEmployees().add((Employee)sourceData);
            } else if (ENTITYSET_1_5.equals(sourceEntitySet.getName())) {
                if (room.getBuilding() != null) {
                    room.getBuilding().getRooms().remove(room);
                }
                room.setBuilding((Building)sourceData);
                ((Building)sourceData).getRooms().add(room);
            }
        } else if (ENTITYSET_1_4.equals(targetEntitySet.getName())) {
            Manager manager = (Manager)this.readData(targetEntitySet, targetKeys);
            if (((Employee)sourceData).getManager() != null) {
                ((Employee)sourceData).getManager().getEmployees().remove(sourceData);
            }
            ((Employee)sourceData).setManager(manager);
            manager.getEmployees().add((Employee)sourceData);
        } else if (ENTITYSET_1_5.equals(targetEntitySet.getName())) {
            Building building = (Building)this.readData(targetEntitySet, targetKeys);
            if (((Room)sourceData).getBuilding() != null) {
                ((Room)sourceData).getBuilding().getRooms().remove(sourceData);
            }
            ((Room)sourceData).setBuilding(building);
            building.getRooms().add((Room)sourceData);
        } else {
            throw new ODataNotImplementedException();
        }
    }

    public static class BinaryData {
        private final byte[] data;
        private final String mimeType;

        public BinaryData(byte[] data, String mimeType) {
            this.data = data;
            this.mimeType = mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String toString() {
            return "data=" + Arrays.toString(this.data) + ", mimeType=" + this.mimeType;
        }
    }
}

