/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.omid.tools.hbase.HBaseLogin;
import org.apache.omid.tools.hbase.SecureHBaseConfig;

public class HBaseConfigModule
extends AbstractModule {
    private String principal;
    private String keytab;

    public HBaseConfigModule(String principal, String keytab) {
        this.principal = principal;
        this.keytab = keytab;
    }

    protected void configure() {
    }

    @Provides
    public Configuration provideHBaseConfig() throws IOException {
        Configuration configuration = HBaseConfiguration.create();
        SecureHBaseConfig secureHBaseConfig = new SecureHBaseConfig();
        secureHBaseConfig.setKeytab(this.keytab);
        secureHBaseConfig.setPrincipal(this.principal);
        HBaseLogin.loginIfNeeded(secureHBaseConfig);
        return configuration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HBaseConfigModule that = (HBaseConfigModule)((Object)o);
        if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) {
            return false;
        }
        return this.keytab != null ? this.keytab.equals(that.keytab) : that.keytab == null;
    }

    public int hashCode() {
        int result = this.principal != null ? this.principal.hashCode() : 0;
        result = 31 * result + (this.keytab != null ? this.keytab.hashCode() : 0);
        return result;
    }
}

