/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.committable;

import java.io.IOException;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ListenableFuture;

public interface CommitTable {
    public static final long INVALID_TRANSACTION_MARKER = -1L;
    public static final int MAX_CHECKPOINTS_PER_TXN = 50;

    public Writer getWriter() throws IOException;

    public Client getClient() throws IOException;

    public static class CommitTimestamp {
        private final Location location;
        private final long value;
        private final boolean isValid;

        public CommitTimestamp(Location location, long value, boolean isValid) {
            this.location = location;
            this.value = value;
            this.isValid = isValid;
        }

        public Location getLocation() {
            return this.location;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String toString() {
            return String.format("Is valid=%s, Location=%s, Value=%d)", new Object[]{this.isValid, this.location, this.value});
        }

        public static enum Location {
            NOT_PRESENT,
            CACHE,
            COMMIT_TABLE,
            SHADOW_CELL;

        }
    }

    public static interface Client {
        public ListenableFuture<Optional<CommitTimestamp>> getCommitTimestamp(long var1);

        public ListenableFuture<Long> readLowWatermark();

        public ListenableFuture<Void> deleteCommitEntry(long var1);

        public ListenableFuture<Boolean> tryInvalidateTransaction(long var1);
    }

    public static interface Writer {
        public void addCommittedTransaction(long var1, long var3) throws IOException;

        public void updateLowWatermark(long var1) throws IOException;

        public void flush() throws IOException;

        public void clearWriteBuffer();

        public boolean atomicAddCommittedTransaction(long var1, long var3) throws IOException;
    }
}

