/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.thirdparty.com.google.common.base.Charsets;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.hash.Hasher;
import org.apache.phoenix.thirdparty.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CellUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CellUtils.class);
    static final byte[] SHADOW_CELL_SUFFIX = "\u0080".getBytes(Charsets.UTF_8);
    static final byte[] SHADOW_CELL_PREFIX = "\u0000\u0080".getBytes(Charsets.UTF_8);
    static byte[] DELETE_TOMBSTONE = HConstants.EMPTY_BYTE_ARRAY;
    static byte[] LEGACY_DELETE_TOMBSTONE = Bytes.toBytes((String)"__OMID_TOMBSTONE__");
    public static final byte[] FAMILY_DELETE_QUALIFIER = HConstants.EMPTY_BYTE_ARRAY;
    public static final String TRANSACTION_ATTRIBUTE = "__OMID_TRANSACTION__";
    public static final String CLIENT_GET_ATTRIBUTE = "__OMID_CLIENT_GET__";
    public static final String LL_ATTRIBUTE = "__OMID_LL__";

    public static boolean hasCell(byte[] row, byte[] family, byte[] qualifier, long version, CellGetter cellGetter) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimestamp(version);
        Result result = cellGetter.get(get);
        return result.containsColumn(family, qualifier);
    }

    public static boolean hasShadowCell(byte[] row, byte[] family, byte[] qualifier, long version, CellGetter cellGetter) throws IOException {
        return CellUtils.hasCell(row, family, CellUtils.addShadowCellSuffixPrefix(qualifier), version, cellGetter);
    }

    public static byte[] addShadowCellSuffixPrefix(byte[] qualifierArray, int qualOffset, int qualLength) {
        byte[] result = new byte[qualLength + SHADOW_CELL_SUFFIX.length + SHADOW_CELL_PREFIX.length];
        System.arraycopy(SHADOW_CELL_PREFIX, 0, result, 0, SHADOW_CELL_PREFIX.length);
        System.arraycopy(qualifierArray, qualOffset, result, SHADOW_CELL_PREFIX.length, qualLength);
        System.arraycopy(SHADOW_CELL_SUFFIX, 0, result, qualLength + SHADOW_CELL_PREFIX.length, SHADOW_CELL_SUFFIX.length);
        return result;
    }

    public static byte[] addShadowCellSuffixPrefix(byte[] qualifier) {
        return CellUtils.addShadowCellSuffixPrefix(qualifier, 0, qualifier.length);
    }

    public static byte[] removeShadowCellSuffixPrefix(byte[] qualifier, int qualOffset, int qualLength) {
        if (CellUtils.endsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_SUFFIX)) {
            if (CellUtils.startsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_PREFIX)) {
                return Arrays.copyOfRange(qualifier, qualOffset + SHADOW_CELL_PREFIX.length, qualOffset + (qualLength - SHADOW_CELL_SUFFIX.length));
            }
            return Arrays.copyOfRange(qualifier, qualOffset, qualOffset + (qualLength - SHADOW_CELL_SUFFIX.length));
        }
        throw new IllegalArgumentException("Can't find shadow cell suffix in qualifier " + Bytes.toString((byte[])qualifier));
    }

    public static int qualifierLengthFromShadowCellQualifier(byte[] qualifier, int qualOffset, int qualLength) {
        if (CellUtils.endsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_SUFFIX)) {
            if (CellUtils.startsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_PREFIX)) {
                return qualLength - SHADOW_CELL_SUFFIX.length - SHADOW_CELL_PREFIX.length;
            }
            return qualLength - SHADOW_CELL_SUFFIX.length;
        }
        return qualLength;
    }

    public static int qualifierOffsetFromShadowCellQualifier(byte[] qualifier, int qualOffset, int qualLength) {
        if (CellUtils.startsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_PREFIX)) {
            return qualOffset + SHADOW_CELL_PREFIX.length;
        }
        return qualOffset;
    }

    public static boolean matchingQualifier(Cell left, byte[] qualArray, int qualOffset, int qualLen) {
        return Bytes.equals((byte[])left.getQualifierArray(), (int)left.getQualifierOffset(), (int)left.getQualifierLength(), (byte[])qualArray, (int)qualOffset, (int)qualLen);
    }

    public static void validateCell(Cell cell, long startTimestamp) {
        if (cell.getTimestamp() != Long.MAX_VALUE && cell.getTimestamp() != startTimestamp) {
            throw new IllegalArgumentException("Timestamp not allowed in transactional user operations");
        }
        if (CellUtils.isShadowCell(cell)) {
            throw new IllegalArgumentException("Reserved string used in column qualifier");
        }
    }

    public static boolean isFamilyDeleteCell(Cell cell) {
        return CellUtil.matchingQualifier((Cell)cell, (byte[])FAMILY_DELETE_QUALIFIER) && CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    public static boolean isShadowCell(Cell cell) {
        byte[] qualifier = cell.getQualifierArray();
        int qualOffset = cell.getQualifierOffset();
        int qualLength = cell.getQualifierLength();
        return CellUtils.endsWith(qualifier, qualOffset, qualLength, SHADOW_CELL_SUFFIX);
    }

    private static boolean endsWith(byte[] value, int offset, int length, byte[] suffix) {
        if (length <= suffix.length) {
            return false;
        }
        int suffixOffset = offset + length - suffix.length;
        int result = Bytes.compareTo((byte[])value, (int)suffixOffset, (int)suffix.length, (byte[])suffix, (int)0, (int)suffix.length);
        return result == 0;
    }

    private static boolean startsWith(byte[] value, int offset, int length, byte[] prefix) {
        if (length <= prefix.length) {
            return false;
        }
        int result = Bytes.compareTo((byte[])value, (int)offset, (int)prefix.length, (byte[])prefix, (int)0, (int)prefix.length);
        return result == 0;
    }

    public static boolean isTombstone(Cell cell) {
        return CellUtil.matchingValue((Cell)cell, (byte[])DELETE_TOMBSTONE) || CellUtil.matchingValue((Cell)cell, (byte[])LEGACY_DELETE_TOMBSTONE);
    }

    public static Cell buildShadowCellFromCell(Cell cell, byte[] shadowCellValue) {
        byte[] shadowCellQualifier = CellUtils.addShadowCellSuffixPrefix(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), shadowCellQualifier, 0, shadowCellQualifier.length, cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), shadowCellValue, 0, shadowCellValue.length);
    }

    public static SortedMap<Cell, Optional<Cell>> mapCellsToShadowCells(List<Cell> cells) {
        TreeMap<Cell, Optional<Cell>> cellToShadowCellMap = new TreeMap<Cell, Optional<Cell>>((Comparator<Cell>)CellComparatorImpl.COMPARATOR);
        HashMap<CellId, Cell> cellIdToCellMap = new HashMap<CellId, Cell>();
        HashMap<CellId, Cell> cellIdToSCCellMap = new HashMap<CellId, Cell>();
        for (Cell cell : cells) {
            CellId key;
            if (!CellUtils.isShadowCell(cell)) {
                key = new CellId(cell, false);
                Cell storedCell = (Cell)cellIdToCellMap.get(key);
                if (storedCell != null) {
                    if (CellUtil.matchingValue((Cell)cell, (Cell)storedCell)) continue;
                    if (cell.getSequenceId() > storedCell.getSequenceId()) {
                        Optional previousValue = (Optional)cellToShadowCellMap.remove(storedCell);
                        Preconditions.checkNotNull((Object)previousValue, (Object)"Should contain an Optional<Cell> value");
                        cellIdToCellMap.put(key, cell);
                        cellToShadowCellMap.put(cell, (Optional<Cell>)previousValue);
                        continue;
                    }
                    LOG.warn("Cell {} with an earlier MVCC found. Ignoring...", (Object)cell);
                    continue;
                }
                cellIdToCellMap.put(key, cell);
                Cell sc = (Cell)cellIdToSCCellMap.get(key);
                if (sc != null) {
                    cellToShadowCellMap.put(cell, (Optional<Cell>)Optional.of((Object)sc));
                    continue;
                }
                cellToShadowCellMap.put(cell, (Optional<Cell>)Optional.absent());
                continue;
            }
            key = new CellId(cell, true);
            Cell savedCell = (Cell)cellIdToCellMap.get(key);
            if (savedCell != null) {
                Cell originalCell = savedCell;
                cellToShadowCellMap.put(originalCell, (Optional<Cell>)Optional.of((Object)cell));
                continue;
            }
            cellIdToSCCellMap.put(key, cell);
        }
        return cellToShadowCellMap;
    }

    private static class CellId {
        private static final int MIN_BITS = 32;
        private final Cell cell;
        private final boolean isShadowCell;

        CellId(Cell cell, boolean isShadowCell) {
            this.cell = cell;
            this.isShadowCell = isShadowCell;
        }

        Cell getCell() {
            return this.cell;
        }

        boolean isShadowCell() {
            return this.isShadowCell;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CellId)) {
                return false;
            }
            CellId otherCellId = (CellId)o;
            Cell otherCell = otherCellId.getCell();
            if (!CellUtil.matchingRows((Cell)otherCell, (Cell)this.cell)) {
                return false;
            }
            if (!CellUtil.matchingFamily((Cell)otherCell, (Cell)this.cell)) {
                return false;
            }
            int qualifierLength = this.cell.getQualifierLength();
            int qualifierOffset = this.cell.getQualifierOffset();
            int otherQualifierLength = otherCell.getQualifierLength();
            int otherQualifierOffset = otherCell.getQualifierOffset();
            if (this.isShadowCell()) {
                qualifierLength = CellUtils.qualifierLengthFromShadowCellQualifier(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength());
                qualifierOffset = CellUtils.qualifierOffsetFromShadowCellQualifier(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength());
            }
            if (otherCellId.isShadowCell()) {
                otherQualifierLength = CellUtils.qualifierLengthFromShadowCellQualifier(otherCell.getQualifierArray(), otherCell.getQualifierOffset(), otherCell.getQualifierLength());
                otherQualifierOffset = CellUtils.qualifierOffsetFromShadowCellQualifier(otherCell.getQualifierArray(), otherCell.getQualifierOffset(), otherCell.getQualifierLength());
            }
            if (!Bytes.equals((byte[])this.cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength, (byte[])otherCell.getQualifierArray(), (int)otherQualifierOffset, (int)otherQualifierLength)) {
                return false;
            }
            return otherCell.getTimestamp() == this.cell.getTimestamp();
        }

        public int hashCode() {
            Hasher hasher = Hashing.goodFastHash((int)32).newHasher();
            hasher.putBytes(this.cell.getRowArray(), this.cell.getRowOffset(), (int)this.cell.getRowLength());
            hasher.putBytes(this.cell.getFamilyArray(), this.cell.getFamilyOffset(), (int)this.cell.getFamilyLength());
            int qualifierLength = this.cell.getQualifierLength();
            int qualifierOffset = this.cell.getQualifierOffset();
            if (this.isShadowCell()) {
                qualifierLength = CellUtils.qualifierLengthFromShadowCellQualifier(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength());
                if (CellUtils.startsWith(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength(), SHADOW_CELL_PREFIX)) {
                    qualifierOffset += SHADOW_CELL_PREFIX.length;
                }
            }
            hasher.putBytes(this.cell.getQualifierArray(), qualifierOffset, qualifierLength);
            hasher.putLong(this.cell.getTimestamp());
            return hasher.hash().asInt();
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
            helper.add("row", (Object)Bytes.toStringBinary((byte[])this.cell.getRowArray(), (int)this.cell.getRowOffset(), (int)this.cell.getRowLength()));
            helper.add("family", (Object)Bytes.toString((byte[])this.cell.getFamilyArray(), (int)this.cell.getFamilyOffset(), (int)this.cell.getFamilyLength()));
            helper.add("is shadow cell?", this.isShadowCell);
            helper.add("qualifier", (Object)Bytes.toString((byte[])this.cell.getQualifierArray(), (int)this.cell.getQualifierOffset(), (int)this.cell.getQualifierLength()));
            if (this.isShadowCell()) {
                int qualifierLength = CellUtils.qualifierLengthFromShadowCellQualifier(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength());
                byte[] cellWithoutSc = CellUtils.removeShadowCellSuffixPrefix(this.cell.getQualifierArray(), this.cell.getQualifierOffset(), this.cell.getQualifierLength());
                helper.add("qualifier whithout shadow cell suffix", (Object)Bytes.toString((byte[])cellWithoutSc));
            }
            helper.add("ts", this.cell.getTimestamp());
            return helper.toString();
        }
    }

    static interface CellGetter {
        public Result get(Get var1) throws IOException;
    }
}

