/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.transaction.AttributeSetSnapshotFilter;
import org.apache.omid.transaction.CellUtils;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.HBaseTransactionManager;
import org.apache.omid.transaction.HTableAccessWrapper;
import org.apache.omid.transaction.SnapshotFilter;
import org.apache.omid.transaction.SnapshotFilterImpl;
import org.apache.omid.transaction.Transaction;
import org.apache.omid.transaction.TransactionManager;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTable
implements Closeable {
    private static Logger LOG = LoggerFactory.getLogger(TTable.class);
    private Table table;
    private SnapshotFilter snapshotFilter;
    private boolean serverSideFilter;
    private final List<Mutation> mutations;
    private boolean autoFlush = true;
    private final boolean conflictFree;

    public TTable(Connection connection, byte[] tableName) throws IOException {
        this(connection.getTable(TableName.valueOf((byte[])tableName)), false);
    }

    public TTable(Connection connection, byte[] tableName, CommitTable.Client commitTableClient) throws IOException {
        this(connection.getTable(TableName.valueOf((byte[])tableName)), commitTableClient, false);
    }

    public TTable(Connection connection, String tableName) throws IOException {
        this(connection.getTable(TableName.valueOf((String)tableName)), false);
    }

    public TTable(Connection connection, String tableName, CommitTable.Client commitTableClient) throws IOException {
        this(connection.getTable(TableName.valueOf((String)tableName)), commitTableClient, false);
    }

    public TTable(Table hTable) throws IOException {
        this(hTable, hTable.getConfiguration().getBoolean("omid.server.side.filter", false), false);
    }

    public TTable(Connection connection, byte[] tableName, boolean conflictFree) throws IOException {
        this(connection.getTable(TableName.valueOf((byte[])tableName)), conflictFree);
    }

    public TTable(Connection connection, byte[] tableName, CommitTable.Client commitTableClient, boolean conflictFree) throws IOException {
        this(connection.getTable(TableName.valueOf((byte[])tableName)), commitTableClient, conflictFree);
    }

    public TTable(Connection connection, String tableName, boolean conflictFree) throws IOException {
        this(connection.getTable(TableName.valueOf((String)tableName)), conflictFree);
    }

    public TTable(Connection connection, String tableName, CommitTable.Client commitTableClient, boolean conflictFree) throws IOException {
        this(connection.getTable(TableName.valueOf((String)tableName)), commitTableClient, conflictFree);
    }

    public TTable(Table hTable, boolean conflictFree) throws IOException {
        this(hTable, hTable.getConfiguration().getBoolean("omid.server.side.filter", false), conflictFree);
    }

    public TTable(Table hTable, SnapshotFilter snapshotFilter) throws IOException {
        this(hTable, snapshotFilter, false);
    }

    public TTable(Table hTable, CommitTable.Client commitTableClient) throws IOException {
        this(hTable, commitTableClient, false);
    }

    public TTable(Table hTable, boolean serverSideFilter, boolean conflictFree) throws IOException {
        this.table = hTable;
        this.conflictFree = conflictFree;
        this.mutations = new ArrayList<Mutation>();
        this.serverSideFilter = serverSideFilter;
        this.snapshotFilter = serverSideFilter ? new AttributeSetSnapshotFilter(hTable) : new SnapshotFilterImpl(new HTableAccessWrapper(hTable, hTable));
    }

    public TTable(Table hTable, SnapshotFilter snapshotFilter, boolean conflictFree) throws IOException {
        this.table = hTable;
        this.conflictFree = conflictFree;
        this.mutations = new ArrayList<Mutation>();
        this.snapshotFilter = snapshotFilter;
    }

    public TTable(Table hTable, CommitTable.Client commitTableClient, boolean conflictFree) throws IOException {
        this.table = hTable;
        this.conflictFree = conflictFree;
        this.mutations = new ArrayList<Mutation>();
        this.serverSideFilter = this.table.getConfiguration().getBoolean("omid.server.side.filter", false);
        this.snapshotFilter = this.serverSideFilter ? new AttributeSetSnapshotFilter(hTable) : new SnapshotFilterImpl(new HTableAccessWrapper(hTable, hTable), commitTableClient);
    }

    @Override
    public void close() throws IOException {
        this.table.close();
        try {
            this.snapshotFilter.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close TTable resources.");
            e.printStackTrace();
        }
    }

    public Result get(Transaction tx, Get get) throws IOException {
        this.throwExceptionIfOpSetsTimerange(get);
        this.flushCommits();
        HBaseTransaction transaction = this.enforceHBaseTransactionAsParam(tx);
        long readTimestamp = transaction.getReadTimestamp();
        Get tsget = new Get(get.getRow()).setFilter(get.getFilter());
        TTable.propagateAttributes((OperationWithAttributes)get, (OperationWithAttributes)tsget);
        TimeRange timeRange = get.getTimeRange();
        long startTime = timeRange.getMin();
        long endTime = Math.min(timeRange.getMax(), readTimestamp + 1L);
        tsget.setTimeRange(startTime, endTime).readVersions(1);
        Map kvs = get.getFamilyMap();
        for (Map.Entry entry : kvs.entrySet()) {
            byte[] family = (byte[])entry.getKey();
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            if (qualifiers == null || qualifiers.isEmpty()) {
                tsget.addFamily(family);
                continue;
            }
            for (byte[] qualifier : qualifiers) {
                tsget.addColumn(family, qualifier);
                tsget.addColumn(family, CellUtils.addShadowCellSuffixPrefix(qualifier));
            }
            tsget.addColumn(family, CellUtils.FAMILY_DELETE_QUALIFIER);
            tsget.addColumn(family, CellUtils.addShadowCellSuffixPrefix(CellUtils.FAMILY_DELETE_QUALIFIER));
        }
        LOG.trace("Initial Get = {}", (Object)tsget);
        return this.snapshotFilter.get(tsget, transaction);
    }

    private static void propagateAttributes(OperationWithAttributes from, OperationWithAttributes to) {
        Map attributeMap = from.getAttributesMap();
        for (Map.Entry entry : attributeMap.entrySet()) {
            to.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    private void familyQualifierBasedDeletion(HBaseTransaction tx, Put deleteP, Get deleteG) throws IOException {
        Result result = this.get((Transaction)tx, deleteG);
        if (!result.isEmpty()) {
            for (Map.Entry entryF : result.getMap().entrySet()) {
                byte[] family = (byte[])entryF.getKey();
                for (Map.Entry entryQ : ((NavigableMap)entryF.getValue()).entrySet()) {
                    byte[] qualifier = (byte[])entryQ.getKey();
                    this.addWriteSetElement(tx, new HBaseCellId(this, deleteP.getRow(), family, qualifier, tx.getWriteTimestamp()));
                }
                deleteP.addColumn(family, CellUtils.FAMILY_DELETE_QUALIFIER, tx.getWriteTimestamp(), CellUtils.DELETE_TOMBSTONE);
                this.addWriteSetElement(tx, new HBaseCellId(this, deleteP.getRow(), family, CellUtils.FAMILY_DELETE_QUALIFIER, tx.getWriteTimestamp()));
            }
        }
    }

    private void familyQualifierBasedDeletionWithOutRead(HBaseTransaction tx, Put deleteP, Get deleteG) {
        Set fset = deleteG.getFamilyMap().keySet();
        for (byte[] family : fset) {
            deleteP.addColumn(family, CellUtils.FAMILY_DELETE_QUALIFIER, tx.getWriteTimestamp(), CellUtils.DELETE_TOMBSTONE);
            this.addWriteSetElement(tx, new HBaseCellId(this, deleteP.getRow(), family, CellUtils.FAMILY_DELETE_QUALIFIER, tx.getWriteTimestamp()));
        }
    }

    public void delete(Transaction tx, Delete delete) throws IOException {
        Put deleteP = this.deleteInternal(tx, delete);
        if (!deleteP.isEmpty()) {
            this.addMutation((Mutation)deleteP);
        }
    }

    private Put deleteInternal(Transaction tx, Delete delete) throws IOException {
        this.throwExceptionIfOpSetsTimerange((Mutation)delete);
        HBaseTransaction transaction = this.enforceHBaseTransactionAsParam(tx);
        long writeTimestamp = transaction.getWriteTimestamp();
        boolean deleteFamily = false;
        Put deleteP = new Put(delete.getRow(), writeTimestamp);
        Get deleteG = new Get(delete.getRow());
        TTable.propagateAttributes((OperationWithAttributes)delete, (OperationWithAttributes)deleteP);
        TTable.propagateAttributes((OperationWithAttributes)delete, (OperationWithAttributes)deleteG);
        NavigableMap fmap = delete.getFamilyCellMap();
        if (fmap.isEmpty()) {
            this.familyQualifierBasedDeletion(transaction, deleteP, deleteG);
        }
        for (List cells : fmap.values()) {
            for (Cell cell : cells) {
                CellUtils.validateCell(cell, writeTimestamp);
                switch (cell.getType()) {
                    case DeleteColumn: {
                        deleteP.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), writeTimestamp, CellUtils.DELETE_TOMBSTONE);
                        this.addWriteSetElement(transaction, new HBaseCellId(this, delete.getRow(), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), writeTimestamp));
                        break;
                    }
                    case DeleteFamily: {
                        deleteG.addFamily(CellUtil.cloneFamily((Cell)cell));
                        deleteFamily = true;
                        break;
                    }
                    case Delete: {
                        if (cell.getTimestamp() == Long.MAX_VALUE) {
                            deleteP.addColumn(CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), writeTimestamp, CellUtils.DELETE_TOMBSTONE);
                            this.addWriteSetElement(transaction, new HBaseCellId(this, delete.getRow(), CellUtil.cloneFamily((Cell)cell), CellUtil.cloneQualifier((Cell)cell), writeTimestamp));
                            break;
                        }
                        throw new UnsupportedOperationException("Cannot delete specific versions on Snapshot Isolation.");
                    }
                }
            }
        }
        if (deleteFamily) {
            if (this.enforceHBaseTransactionManagerAsParam(transaction.getTransactionManager()).getConflictDetectionLevel() == OmidClientConfiguration.ConflictDetectionLevel.ROW) {
                this.familyQualifierBasedDeletionWithOutRead(transaction, deleteP, deleteG);
            } else {
                this.familyQualifierBasedDeletion(transaction, deleteP, deleteG);
            }
        }
        return deleteP;
    }

    public void put(Transaction tx, Put put) throws IOException {
        this.put(tx, put, false);
    }

    public static Put markPutAsCommitted(Put put, long timestamp, long commitTimestamp) {
        Put tsput = new Put(put.getRow(), timestamp);
        TTable.propagateAttributes((OperationWithAttributes)put, (OperationWithAttributes)tsput);
        NavigableMap kvs = put.getFamilyCellMap();
        for (List kvl : kvs.values()) {
            for (Cell c : kvl) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                Bytes.putLong((byte[])kv.getValueArray(), (int)kv.getTimestampOffset(), (long)timestamp);
                try {
                    tsput.add((Cell)kv);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                tsput.addColumn(CellUtil.cloneFamily((Cell)kv), CellUtils.addShadowCellSuffixPrefix(CellUtil.cloneQualifier((Cell)kv), 0, CellUtil.cloneQualifier((Cell)kv).length), kv.getTimestamp(), Bytes.toBytes((long)commitTimestamp));
            }
        }
        return tsput;
    }

    public void put(Transaction tx, Put put, boolean addShadowCell) throws IOException {
        Put tsput = this.putInternal(tx, put, addShadowCell);
        this.addMutation((Mutation)tsput);
    }

    private Put putInternal(Transaction tx, Put put, boolean addShadowCell) throws IOException {
        this.throwExceptionIfOpSetsTimerange((Mutation)put);
        HBaseTransaction transaction = this.enforceHBaseTransactionAsParam(tx);
        long writeTimestamp = transaction.getWriteTimestamp();
        Put tsput = new Put(put.getRow(), writeTimestamp);
        TTable.propagateAttributes((OperationWithAttributes)put, (OperationWithAttributes)tsput);
        NavigableMap kvs = put.getFamilyCellMap();
        for (List kvl : kvs.values()) {
            for (Cell c : kvl) {
                CellUtils.validateCell(c, writeTimestamp);
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                Bytes.putLong((byte[])kv.getValueArray(), (int)kv.getTimestampOffset(), (long)writeTimestamp);
                tsput.add((Cell)kv);
                if (addShadowCell) {
                    tsput.addColumn(CellUtil.cloneFamily((Cell)kv), CellUtils.addShadowCellSuffixPrefix(CellUtil.cloneQualifier((Cell)kv), 0, CellUtil.cloneQualifier((Cell)kv).length), kv.getTimestamp(), Bytes.toBytes((long)kv.getTimestamp()));
                    continue;
                }
                HBaseCellId cellId = new HBaseCellId(this, CellUtil.cloneRow((Cell)kv), CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), kv.getTimestamp());
                this.addWriteSetElement(transaction, cellId);
            }
        }
        return tsput;
    }

    private void addWriteSetElement(HBaseTransaction transaction, HBaseCellId cellId) {
        if (this.conflictFree) {
            transaction.addConflictFreeWriteSetElement(cellId);
        } else {
            transaction.addWriteSetElement(cellId);
        }
    }

    private void addMutation(Mutation m) throws IOException {
        this.mutations.add(m);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    private void addMutations(List<Mutation> mutations) throws IOException {
        this.mutations.addAll(mutations);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    public ResultScanner getScanner(Transaction tx, Scan scan) throws IOException {
        this.throwExceptionIfOpSetsTimerange(scan);
        this.flushCommits();
        HBaseTransaction transaction = this.enforceHBaseTransactionAsParam(tx);
        Scan tsscan = new Scan(scan);
        tsscan.readVersions(1);
        tsscan.setTimeRange(0L, transaction.getReadTimestamp() + 1L);
        TTable.propagateAttributes((OperationWithAttributes)scan, (OperationWithAttributes)tsscan);
        Map kvs = scan.getFamilyMap();
        for (Map.Entry entry : kvs.entrySet()) {
            byte[] family = (byte[])entry.getKey();
            NavigableSet qualifiers = (NavigableSet)entry.getValue();
            if (qualifiers == null) continue;
            for (byte[] qualifier : qualifiers) {
                tsscan.addColumn(family, CellUtils.addShadowCellSuffixPrefix(qualifier));
            }
            if (qualifiers.isEmpty()) continue;
            tsscan.addColumn((byte[])entry.getKey(), CellUtils.FAMILY_DELETE_QUALIFIER);
        }
        return this.snapshotFilter.getScanner(tsscan, transaction);
    }

    public Table getHBaseTable() {
        return this.table;
    }

    public byte[] getTableName() {
        return this.table.getName().getName();
    }

    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.table.getTableDescriptor();
    }

    public TableDescriptor getDescriptor() throws IOException {
        return this.table.getDescriptor();
    }

    public boolean exists(Transaction transaction, Get get) throws IOException {
        Result result = this.get(transaction, get);
        return !result.isEmpty();
    }

    public Result[] get(Transaction transaction, List<Get> gets) throws IOException {
        Result[] results = new Result[gets.size()];
        int i = 0;
        for (Get get : gets) {
            results[i++] = this.get(transaction, get);
        }
        return results;
    }

    public ResultScanner getScanner(Transaction transaction, byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(transaction, scan);
    }

    public ResultScanner getScanner(Transaction transaction, byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(transaction, scan);
    }

    public void put(Transaction transaction, List<Put> puts, boolean addShadowCells) throws IOException {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(puts.size());
        for (Put put : puts) {
            mutations.add((Mutation)this.putInternal(transaction, put, addShadowCells));
        }
        this.addMutations(mutations);
    }

    public void put(Transaction transaction, List<Put> puts) throws IOException {
        this.put(transaction, puts, false);
    }

    public void batch(Transaction transaction, List<? extends Row> rows, boolean addShadowCells) throws IOException {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(rows.size());
        for (Row row : rows) {
            if (row instanceof Put) {
                mutations.add((Mutation)this.putInternal(transaction, (Put)row, addShadowCells));
                continue;
            }
            if (row instanceof Delete) {
                Put deleteP = this.deleteInternal(transaction, (Delete)row);
                if (deleteP.isEmpty()) continue;
                mutations.add((Mutation)deleteP);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported mutation: " + row);
        }
        this.addMutations(mutations);
    }

    public void batch(Transaction transaction, List<? extends Row> rows) throws IOException {
        this.batch(transaction, rows, false);
    }

    public void delete(Transaction transaction, List<Delete> deletes) throws IOException {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(deletes.size());
        for (Delete delete : deletes) {
            Put deleteP = this.deleteInternal(transaction, delete);
            if (deleteP.isEmpty()) continue;
            mutations.add((Mutation)deleteP);
        }
        this.addMutations(mutations);
    }

    public Table getHTable() {
        return this.table;
    }

    public void setAutoFlush(boolean autoFlush) throws IOException {
        this.autoFlush = autoFlush;
        this.flushCommits();
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void flushCommits() throws IOException {
        try {
            if (this.mutations.size() > 0) {
                this.table.batch(this.mutations, new Object[this.mutations.size()]);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        finally {
            this.mutations.clear();
        }
    }

    private void throwExceptionIfOpSetsTimerange(Get getOperation) {
        TimeRange tr = getOperation.getTimeRange();
        this.checkTimerangeIsSetToDefaultValuesOrThrowException(tr);
    }

    private void throwExceptionIfOpSetsTimerange(Scan scanOperation) {
        TimeRange tr = scanOperation.getTimeRange();
        this.checkTimerangeIsSetToDefaultValuesOrThrowException(tr);
    }

    private void checkTimerangeIsSetToDefaultValuesOrThrowException(TimeRange tr) {
        if (tr.getMin() != 0L || tr.getMax() != Long.MAX_VALUE) {
            throw new IllegalArgumentException("Timestamp/timerange not allowed in transactional user operations");
        }
    }

    private void throwExceptionIfOpSetsTimerange(Mutation userOperation) {
        if (userOperation.getTimestamp() != Long.MAX_VALUE) {
            throw new IllegalArgumentException("Timestamp not allowed in transactional user operations");
        }
    }

    private HBaseTransaction enforceHBaseTransactionAsParam(Transaction tx) {
        if (tx instanceof HBaseTransaction) {
            return (HBaseTransaction)tx;
        }
        throw new IllegalArgumentException(String.format("The transaction object passed %s is not an instance of HBaseTransaction", tx.getClass().getName()));
    }

    private HBaseTransactionManager enforceHBaseTransactionManagerAsParam(TransactionManager tm) {
        if (tm instanceof HBaseTransactionManager) {
            return (HBaseTransactionManager)tm;
        }
        throw new IllegalArgumentException(String.format("The transaction manager object passed %s is not an instance of HBaseTransactionManager ", tm.getClass().getName()));
    }
}

