/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.CellUtils;
import org.apache.omid.transaction.HBaseTransaction;
import org.apache.omid.transaction.SnapshotFilterImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;

public class TransactionVisibilityFilterBase
extends FilterBase {
    private final Filter userFilter;
    private final SnapshotFilterImpl snapshotFilter;
    private final LRUMap<Long, Long> commitCache;
    private final HBaseTransaction hbaseTransaction;
    private final Map<ImmutableBytesWritable, Long> familyDeletionCache;

    public TransactionVisibilityFilterBase(Filter cellFilter, SnapshotFilterImpl snapshotFilter, HBaseTransaction hbaseTransaction) {
        this.userFilter = cellFilter;
        this.snapshotFilter = snapshotFilter;
        this.commitCache = new LRUMap(1000);
        this.hbaseTransaction = hbaseTransaction;
        this.familyDeletionCache = new HashMap<ImmutableBytesWritable, Long>();
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        return this.filterCell(cell);
    }

    public Filter.ReturnCode filterCell(Cell v) throws IOException {
        if (CellUtils.isShadowCell(v)) {
            Long commitTs = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)v));
            this.commitCache.put((Object)v.getTimestamp(), (Object)commitTs);
            if (this.hbaseTransaction.getStartTimestamp() >= commitTs) {
                return Filter.ReturnCode.NEXT_COL;
            }
            return Filter.ReturnCode.SKIP;
        }
        Optional<Long> commitTS = this.getCommitIfInSnapshot(v, CellUtils.isFamilyDeleteCell(v));
        if (commitTS.isPresent()) {
            if (this.hbaseTransaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL && this.snapshotFilter.getTSIfInTransaction(v, this.hbaseTransaction).isPresent()) {
                return this.runUserFilter(v, Filter.ReturnCode.INCLUDE);
            }
            if (CellUtils.isFamilyDeleteCell(v)) {
                this.familyDeletionCache.put(this.createImmutableBytesWritable(v), (Long)commitTS.get());
                if (this.hbaseTransaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL) {
                    return this.runUserFilter(v, Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
                }
                return Filter.ReturnCode.NEXT_COL;
            }
            Long deleteCommit = this.familyDeletionCache.get(this.createImmutableBytesWritable(v));
            if (deleteCommit != null && deleteCommit >= v.getTimestamp()) {
                if (this.hbaseTransaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL) {
                    return this.runUserFilter(v, Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
                }
                return Filter.ReturnCode.NEXT_COL;
            }
            if (CellUtils.isTombstone(v)) {
                if (this.hbaseTransaction.getVisibilityLevel() == AbstractTransaction.VisibilityLevel.SNAPSHOT_ALL) {
                    return this.runUserFilter(v, Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
                }
                return Filter.ReturnCode.NEXT_COL;
            }
            return this.runUserFilter(v, Filter.ReturnCode.INCLUDE_AND_NEXT_COL);
        }
        return Filter.ReturnCode.SKIP;
    }

    private ImmutableBytesWritable createImmutableBytesWritable(Cell v) {
        return new ImmutableBytesWritable(v.getFamilyArray(), v.getFamilyOffset(), (int)v.getFamilyLength());
    }

    private Filter.ReturnCode runUserFilter(Cell v, Filter.ReturnCode snapshotReturn) throws IOException {
        assert (snapshotReturn == Filter.ReturnCode.INCLUDE_AND_NEXT_COL || snapshotReturn == Filter.ReturnCode.INCLUDE);
        if (this.userFilter == null) {
            return snapshotReturn;
        }
        Filter.ReturnCode userRes = this.userFilter.filterCell(v);
        switch (userRes) {
            case INCLUDE: {
                return snapshotReturn;
            }
            case SKIP: {
                return snapshotReturn == Filter.ReturnCode.INCLUDE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.NEXT_COL;
            }
        }
        return userRes;
    }

    private Optional<Long> getCommitIfInSnapshot(Cell v, boolean getShadowCellBeforeCT) throws IOException {
        Optional<Long> commitTS;
        Long cachedCommitTS = (Long)this.commitCache.get((Object)v.getTimestamp());
        if (cachedCommitTS != null) {
            if (this.hbaseTransaction.getStartTimestamp() >= cachedCommitTS) {
                return Optional.of((Object)cachedCommitTS);
            }
            return Optional.absent();
        }
        if (this.snapshotFilter.getTSIfInTransaction(v, this.hbaseTransaction).isPresent()) {
            return Optional.of((Object)v.getTimestamp());
        }
        if (getShadowCellBeforeCT) {
            Get get = new Get(CellUtil.cloneRow((Cell)v));
            get.setTimestamp(v.getTimestamp()).readVersions(1);
            get.addColumn(CellUtil.cloneFamily((Cell)v), CellUtils.addShadowCellSuffixPrefix(CellUtils.FAMILY_DELETE_QUALIFIER));
            Result shadowCell = this.snapshotFilter.getTableAccessWrapper().get(get);
            if (!shadowCell.isEmpty()) {
                long commitTS2 = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)shadowCell.rawCells()[0]));
                this.commitCache.put((Object)v.getTimestamp(), (Object)commitTS2);
                if (commitTS2 <= this.hbaseTransaction.getStartTimestamp()) {
                    return Optional.of((Object)commitTS2);
                }
            }
        }
        if ((commitTS = this.snapshotFilter.getTSIfInSnapshot(v, this.hbaseTransaction, (Map<Long, Long>)this.commitCache)).isPresent()) {
            this.commitCache.put((Object)v.getTimestamp(), commitTS.get());
        } else {
            this.commitCache.put((Object)v.getTimestamp(), (Object)Long.MAX_VALUE);
        }
        return commitTS;
    }

    public void reset() throws IOException {
        this.familyDeletionCache.clear();
        if (this.userFilter != null) {
            this.userFilter.reset();
        }
    }

    public boolean filterRow() throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.filterRow();
        }
        return super.filterRow();
    }

    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.filterRowKey(buffer, offset, length);
        }
        return super.filterRowKey(buffer, offset, length);
    }

    public boolean filterRowKey(Cell cell) throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.filterRowKey(cell);
        }
        return super.filterRowKey(cell);
    }

    public boolean filterAllRemaining() throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.filterAllRemaining();
        }
        return super.filterAllRemaining();
    }

    public void filterRowCells(List<Cell> kvs) throws IOException {
        if (this.userFilter != null) {
            this.userFilter.filterRowCells(kvs);
        } else {
            super.filterRowCells(kvs);
        }
    }

    public boolean hasFilterRow() {
        if (this.userFilter != null) {
            return this.userFilter.hasFilterRow();
        }
        return super.hasFilterRow();
    }

    public Cell getNextCellHint(Cell currentKV) throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.getNextCellHint(currentKV);
        }
        return super.getNextCellHint(currentKV);
    }

    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.userFilter != null) {
            return this.userFilter.isFamilyEssential(name);
        }
        return super.isFamilyEssential(name);
    }

    public byte[] toByteArray() throws IOException {
        return super.toByteArray();
    }

    public Filter getInnerFilter() {
        return this.userFilter;
    }
}

