/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tools.hbase;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.committable.hbase.KeyGenerator;
import org.apache.omid.committable.hbase.KeyGeneratorImplementations;
import org.apache.omid.committable.hbase.RegionSplitter;
import org.apache.omid.tools.hbase.HBaseLogin;
import org.apache.omid.tools.hbase.SecureHBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmidTableManager {
    private static final Logger LOG = LoggerFactory.getLogger(OmidTableManager.class);
    public static final String COMMIT_TABLE_COMMAND_NAME = "commit-table";
    static final String TIMESTAMP_TABLE_COMMAND_NAME = "timestamp-table";
    private static final byte[][] commitTableFamilies = new byte[][]{Bytes.toBytes((String)"F"), Bytes.toBytes((String)"LWF")};
    private static final byte[][] timestampTableFamilies = new byte[][]{Bytes.toBytes((String)"MAX_TIMESTAMP_CF")};
    private JCommander commandLine;
    private MainConfig mainConfig = new MainConfig();
    private CommitTableCommand commitTableCommand = new CommitTableCommand();
    private TimestampTableCommand timestampTableCommand = new TimestampTableCommand();

    public OmidTableManager(String ... args) {
        this.commandLine = new JCommander((Object)this.mainConfig);
        this.commandLine.addCommand(COMMIT_TABLE_COMMAND_NAME, (Object)this.commitTableCommand);
        this.commandLine.addCommand(TIMESTAMP_TABLE_COMMAND_NAME, (Object)this.timestampTableCommand);
        try {
            this.commandLine.parse(args);
        }
        catch (ParameterException ex) {
            this.commandLine.usage();
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void executeActionsOnHBase(Configuration hbaseConf) throws IOException {
        this.mainConfig.loginFlags.setPrincipal(hbaseConf.get("hbase.client.principal"));
        this.mainConfig.loginFlags.setKeytab(hbaseConf.get("hbase.client.keytab"));
        HBaseLogin.loginIfNeeded((SecureHBaseConfig)this.mainConfig.loginFlags, (Configuration)hbaseConf);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
             Admin hBaseAdmin = conn.getAdmin();){
            byte[][] tableFamilies;
            String tableName;
            byte[][] splitKeys = new byte[0][0];
            LOG.info("----------------------------------------------------------------------------------------------");
            switch (this.commandLine.getParsedCommand()) {
                case "commit-table": {
                    LOG.info("Performing actions related to COMMIT TABLE");
                    tableName = this.commitTableCommand.tableName;
                    tableFamilies = commitTableFamilies;
                    if (this.commitTableCommand.numRegions <= 1) break;
                    splitKeys = OmidTableManager.splitInUniformRegions(hbaseConf, this.commitTableCommand.numRegions);
                    break;
                }
                case "timestamp-table": {
                    LOG.info("Performing actions related to TIMESTAMP TABLE");
                    tableName = this.timestampTableCommand.tableName;
                    tableFamilies = timestampTableFamilies;
                    break;
                }
                default: {
                    LOG.error("Unknown command: {}", (Object)this.commandLine.getParsedCommand());
                    this.commandLine.usage();
                    return;
                }
            }
            OmidTableManager.createTable(hBaseAdmin, tableName, tableFamilies, splitKeys, 1);
            LOG.info("----------------------------------------------------------------------------------------------");
        }
    }

    public static void main(String ... args) throws Exception {
        OmidTableManager tableManager = new OmidTableManager(args);
        tableManager.executeActionsOnHBase(HBaseConfiguration.create());
    }

    private static byte[][] splitInUniformRegions(Configuration hBaseConf, int numRegions) throws IOException {
        KeyGenerator keyGen = KeyGeneratorImplementations.defaultKeyGenerator();
        RegionSplitter.SplitAlgorithm algo = RegionSplitter.newSplitAlgoInstance((Configuration)hBaseConf, (String)RegionSplitter.UniformSplit.class.getName());
        algo.setFirstRow(algo.rowToStr(keyGen.startTimestampToKey(0L)));
        algo.setLastRow(algo.rowToStr(keyGen.startTimestampToKey(Long.MAX_VALUE)));
        return algo.split(numRegions);
    }

    private static void createTable(Admin admin, String tableName, byte[][] families, byte[][] splitKeys, int maxVersions) throws IOException {
        LOG.info("About to create Table named {} with {} splits", (Object)tableName, (Object)splitKeys.length);
        TableName hTableName = TableName.valueOf((String)tableName);
        if (admin.tableExists(hTableName)) {
            LOG.error("Table {} already exists. Table creation cancelled", (Object)tableName);
            return;
        }
        ArrayList<ColumnFamilyDescriptor> fams = new ArrayList<ColumnFamilyDescriptor>();
        for (byte[] family : families) {
            fams.add(ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMaxVersions(maxVersions).build());
            LOG.info("\tAdding Family {}", fams.get(fams.size() - 1));
        }
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamilies(fams).build();
        admin.createTable(desc, splitKeys);
        LOG.info("Table {} created. Regions: {}", (Object)tableName, (Object)admin.getRegions(hTableName).size());
    }

    public static class IntegerGreaterThanZero
    implements IParameterValidator {
        public void validate(String name, String value) throws ParameterException {
            int n = Integer.parseInt(value);
            if (n <= 0) {
                throw new ParameterException("Parameter " + name + " should be > 0 (found " + value + ")");
            }
        }
    }

    @Parameters(commandDescription="Specifies configuration for the Timestamp Table")
    static class TimestampTableCommand {
        @Parameter(names={"-tableName"}, description="Table name where to store timestamps")
        String tableName = "OMID_TIMESTAMP_TABLE";

        TimestampTableCommand() {
        }
    }

    @Parameters(commandDescription="Specifies configuration for the Commit Table")
    static class CommitTableCommand {
        @Parameter(names={"-tableName"}, description="Table name where to stores the commits", required=false)
        String tableName = "OMID_COMMIT_TABLE";
        @Parameter(names={"-numRegions"}, description="Number of splits (to pre-split tableName)", required=false, validateWith={IntegerGreaterThanZero.class})
        int numRegions = 16;

        CommitTableCommand() {
        }
    }

    static class MainConfig {
        @ParametersDelegate
        SecureHBaseConfig loginFlags = new SecureHBaseConfig();

        MainConfig() {
        }
    }
}

