/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.omid.YAMLUtils;

public class OmidClientConfiguration {
    private static final String DEFAULT_CONFIG_FILE_NAME = "omid-client-config.yml";
    private ConnType connectionType = ConnType.DIRECT;
    private String connectionString;
    private String zkCurrentTsoPath;
    private String zkNamespace;
    private int zkConnectionTimeoutInSecs;
    private int requestMaxRetries;
    private int requestTimeoutInMs;
    private int reconnectionDelayInSecs;
    private int retryDelayInMs;
    private int executorThreads;
    private PostCommitMode postCommitMode = PostCommitMode.SYNC;
    private ConflictDetectionLevel conflictAnalysisLevel = ConflictDetectionLevel.CELL;

    public OmidClientConfiguration() {
        new YAMLUtils().loadSettings(DEFAULT_CONFIG_FILE_NAME, (Object)this);
    }

    public ConnType getConnectionType() {
        return this.connectionType;
    }

    @Inject(optional=true)
    @Named(value="omid.client.connectionType")
    public void setConnectionType(ConnType connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Inject(optional=true)
    @Named(value="omid.client.connectionString")
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public int getZkConnectionTimeoutInSecs() {
        return this.zkConnectionTimeoutInSecs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.zkConnectionTimeoutInSecs")
    public void setZkConnectionTimeoutInSecs(int zkConnectionTimeoutInSecs) {
        this.zkConnectionTimeoutInSecs = zkConnectionTimeoutInSecs;
    }

    public int getRequestMaxRetries() {
        return this.requestMaxRetries;
    }

    @Inject(optional=true)
    @Named(value="omid.client.requestMaxRetries")
    public void setRequestMaxRetries(int requestMaxRetries) {
        this.requestMaxRetries = requestMaxRetries;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.requestTimeoutInMs")
    public void setRequestTimeoutInMs(int requestTimeoutInMs) {
        this.requestTimeoutInMs = requestTimeoutInMs;
    }

    public int getReconnectionDelayInSecs() {
        return this.reconnectionDelayInSecs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.reconnectionDelayInSecs")
    public void setReconnectionDelayInSecs(int reconnectionDelayInSecs) {
        this.reconnectionDelayInSecs = reconnectionDelayInSecs;
    }

    public int getRetryDelayInMs() {
        return this.retryDelayInMs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.retryDelayInMs")
    public void setRetryDelayInMs(int retryDelayInMs) {
        this.retryDelayInMs = retryDelayInMs;
    }

    public int getExecutorThreads() {
        return this.executorThreads;
    }

    @Inject(optional=true)
    @Named(value="omid.client.executorThreads")
    public void setExecutorThreads(int executorThreads) {
        this.executorThreads = executorThreads;
    }

    public String getZkCurrentTsoPath() {
        return this.zkCurrentTsoPath;
    }

    @Inject(optional=true)
    @Named(value="omid.ha.zkCurrentTsoPath")
    public void setZkCurrentTsoPath(String zkCurrentTsoPath) {
        this.zkCurrentTsoPath = zkCurrentTsoPath;
    }

    public String getZkNamespace() {
        return this.zkNamespace;
    }

    @Inject(optional=true)
    @Named(value="omid.ha.zkNamespace")
    public void setZkNamespace(String zkNamespace) {
        this.zkNamespace = zkNamespace;
    }

    public PostCommitMode getPostCommitMode() {
        return this.postCommitMode;
    }

    @Inject(optional=true)
    @Named(value="omid.tm.postCommitMode")
    public void setPostCommitMode(PostCommitMode postCommitMode) {
        this.postCommitMode = postCommitMode;
    }

    public ConflictDetectionLevel getConflictAnalysisLevel() {
        return this.conflictAnalysisLevel;
    }

    @Inject(optional=true)
    @Named(value="omid.tm.conflictAnalysisLevel")
    public void setConflictAnalysisLevel(ConflictDetectionLevel conflictAnalysisLevel) {
        this.conflictAnalysisLevel = conflictAnalysisLevel;
    }

    public static enum ConflictDetectionLevel {
        CELL,
        ROW;

    }

    public static enum PostCommitMode {
        SYNC,
        ASYNC;

    }

    public static enum ConnType {
        DIRECT,
        HA;

    }
}

