/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.omid.YAMLUtils;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class OmidClientConfiguration {
    private static final String DEFAULT_CONFIG_FILE_NAME = "omid-client-config.yml";
    private ConnType connectionType = ConnType.DIRECT;
    private String connectionString;
    private String zkCurrentTsoPath;
    private String zkNamespace;
    private int zkConnectionTimeoutInSecs;
    private int requestMaxRetries;
    private int requestTimeoutInMs;
    private int reconnectionDelayInSecs;
    private int retryDelayInMs;
    private int executorThreads;
    private PostCommitMode postCommitMode = PostCommitMode.SYNC;
    private ConflictDetectionLevel conflictAnalysisLevel = ConflictDetectionLevel.CELL;
    private boolean tlsEnabled = false;
    private int clientNettyTlsHandshakeTimeout = 5000;
    private String keyStoreLocation = "";
    private String keyStorePassword = "";
    private String keyStoreType = "";
    private String trustStoreLocation = "";
    private String trustStorePassword = "";
    private String trustStoreType = "";
    private boolean sslCrlEnabled = false;
    private boolean sslOcspEnabled = false;
    private String enabledProtocols;
    private String cipherSuites;
    private String tlsConfigProtocols = "TLSv1.2";

    public OmidClientConfiguration() {
        new YAMLUtils().loadSettings(DEFAULT_CONFIG_FILE_NAME, (Object)this);
    }

    @VisibleForTesting
    public OmidClientConfiguration(String configFileName) {
        new YAMLUtils().loadSettings(configFileName, DEFAULT_CONFIG_FILE_NAME, (Object)this);
    }

    public ConnType getConnectionType() {
        return this.connectionType;
    }

    @Inject(optional=true)
    @Named(value="omid.client.connectionType")
    public void setConnectionType(ConnType connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Inject(optional=true)
    @Named(value="omid.client.connectionString")
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public int getZkConnectionTimeoutInSecs() {
        return this.zkConnectionTimeoutInSecs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.zkConnectionTimeoutInSecs")
    public void setZkConnectionTimeoutInSecs(int zkConnectionTimeoutInSecs) {
        this.zkConnectionTimeoutInSecs = zkConnectionTimeoutInSecs;
    }

    public int getRequestMaxRetries() {
        return this.requestMaxRetries;
    }

    @Inject(optional=true)
    @Named(value="omid.client.requestMaxRetries")
    public void setRequestMaxRetries(int requestMaxRetries) {
        this.requestMaxRetries = requestMaxRetries;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.requestTimeoutInMs")
    public void setRequestTimeoutInMs(int requestTimeoutInMs) {
        this.requestTimeoutInMs = requestTimeoutInMs;
    }

    public int getReconnectionDelayInSecs() {
        return this.reconnectionDelayInSecs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.reconnectionDelayInSecs")
    public void setReconnectionDelayInSecs(int reconnectionDelayInSecs) {
        this.reconnectionDelayInSecs = reconnectionDelayInSecs;
    }

    public int getRetryDelayInMs() {
        return this.retryDelayInMs;
    }

    @Inject(optional=true)
    @Named(value="omid.client.retryDelayInMs")
    public void setRetryDelayInMs(int retryDelayInMs) {
        this.retryDelayInMs = retryDelayInMs;
    }

    public int getExecutorThreads() {
        return this.executorThreads;
    }

    @Inject(optional=true)
    @Named(value="omid.client.executorThreads")
    public void setExecutorThreads(int executorThreads) {
        this.executorThreads = executorThreads;
    }

    public String getZkCurrentTsoPath() {
        return this.zkCurrentTsoPath;
    }

    @Inject(optional=true)
    @Named(value="omid.ha.zkCurrentTsoPath")
    public void setZkCurrentTsoPath(String zkCurrentTsoPath) {
        this.zkCurrentTsoPath = zkCurrentTsoPath;
    }

    public String getZkNamespace() {
        return this.zkNamespace;
    }

    @Inject(optional=true)
    @Named(value="omid.ha.zkNamespace")
    public void setZkNamespace(String zkNamespace) {
        this.zkNamespace = zkNamespace;
    }

    public PostCommitMode getPostCommitMode() {
        return this.postCommitMode;
    }

    @Inject(optional=true)
    @Named(value="omid.tm.postCommitMode")
    public void setPostCommitMode(PostCommitMode postCommitMode) {
        this.postCommitMode = postCommitMode;
    }

    public ConflictDetectionLevel getConflictAnalysisLevel() {
        return this.conflictAnalysisLevel;
    }

    @Inject(optional=true)
    @Named(value="omid.tm.conflictAnalysisLevel")
    public void setConflictAnalysisLevel(ConflictDetectionLevel conflictAnalysisLevel) {
        this.conflictAnalysisLevel = conflictAnalysisLevel;
    }

    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Inject(optional=true)
    @Named(value="omid.client.tlsEnabled")
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public int getClientNettyTlsHandshakeTimeout() {
        return this.clientNettyTlsHandshakeTimeout;
    }

    @Inject(optional=true)
    @Named(value="omid.client.clientNettyTlsHandshakeTimeout")
    public void setClientNettyTlsHandshakeTimeout(int clientNettyTlsHandshakeTimeout) {
        this.clientNettyTlsHandshakeTimeout = clientNettyTlsHandshakeTimeout;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    @Inject(optional=true)
    @Named(value="omid.client.keyStoreLocation")
    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Inject(optional=true)
    @Named(value="omid.client.keyStorePassword")
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Inject(optional=true)
    @Named(value="omid.client.keyStoreType")
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    @Inject(optional=true)
    @Named(value="omid.client.trustStoreLocation")
    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Inject(optional=true)
    @Named(value="omid.client.trustStorePassword")
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Inject(optional=true)
    @Named(value="omid.client.trustStoreType")
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public boolean getSslCrlEnabled() {
        return this.sslCrlEnabled;
    }

    @Inject(optional=true)
    @Named(value="omid.client.sslCrlEnabled")
    public void setSslCrlEnabled(boolean sslCrlEnabled) {
        this.sslCrlEnabled = sslCrlEnabled;
    }

    public boolean getSslOcspEnabled() {
        return this.sslOcspEnabled;
    }

    @Inject(optional=true)
    @Named(value="omid.client.sslCrlEnabled")
    public void setSslOcspEnabled(boolean sslOcspEnabled) {
        this.sslOcspEnabled = sslOcspEnabled;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Inject(optional=true)
    @Named(value="omid.client.enabledProtocols")
    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String getCipherSuites() {
        return this.cipherSuites;
    }

    @Inject(optional=true)
    @Named(value="omid.client.cipherSuites")
    public void setCipherSuites(String cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String getTsConfigProtocols() {
        return this.tlsConfigProtocols;
    }

    @Inject(optional=true)
    @Named(value="omid.client.tlsConfigProtocols")
    public void setTsConfigProtocols(String tlsConfigProtocols) {
        this.tlsConfigProtocols = tlsConfigProtocols;
    }

    public static enum ConflictDetectionLevel {
        CELL,
        ROW;

    }

    public static enum PostCommitMode {
        SYNC,
        ASYNC;

    }

    public static enum ConnType {
        DIRECT,
        HA;

    }
}

