/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.committable.InMemoryCommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.DisruptorModule;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.LowWatermarkWriterImpl;
import org.apache.omid.tso.MockPanicker;
import org.apache.omid.tso.NetworkInterfaceUtils;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PausableTimestampOracle;
import org.apache.omid.tso.PersistenceProcessorHandler;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.TSOStateManagerImpl;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.omid.tso.WorldClockOracleImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class TSOMockModule
extends AbstractModule {
    private final TSOServerConfig config;

    public TSOMockModule(TSOServerConfig config) {
        Preconditions.checkArgument((config.getNumConcurrentCTWriters() >= 2 ? 1 : 0) != 0, (Object)"# of Commit Table writers must be >= 2");
        this.config = config;
    }

    protected void configure() {
        this.bind(TSOChannelHandler.class).in(Singleton.class);
        this.bind(TSOStateManager.class).to(TSOStateManagerImpl.class).in(Singleton.class);
        this.bind(CommitTable.class).to(InMemoryCommitTable.class).in(Singleton.class);
        this.bind(TimestampStorage.class).to(TimestampOracleImpl.InMemoryTimestampStorage.class).in(Singleton.class);
        if (this.config.getTimestampTypeEnum() == TSOServerConfig.TIMESTAMP_TYPE.WORLD_TIME) {
            this.bind(TimestampOracle.class).to(WorldClockOracleImpl.class).in(Singleton.class);
        } else {
            this.bind(TimestampOracle.class).to(PausableTimestampOracle.class).in(Singleton.class);
        }
        this.bind(Panicker.class).to(MockPanicker.class).in(Singleton.class);
        this.bind(LowWatermarkWriter.class).to(LowWatermarkWriterImpl.class).in(Singleton.class);
        this.install((Module)new BatchPoolModule(this.config));
        this.install(this.config.getLeaseModule());
        this.install((Module)new DisruptorModule(this.config));
    }

    @Provides
    TSOServerConfig provideTSOServerConfig() {
        return this.config;
    }

    @Provides
    @Singleton
    MetricsRegistry provideMetricsRegistry() {
        return new NullMetricsProvider();
    }

    @Provides
    @Named(value="tso.hostandport")
    String provideTSOHostAndPort() throws SocketException, UnknownHostException {
        return NetworkInterfaceUtils.getTSOHostAndPort((TSOServerConfig)this.config);
    }

    @Provides
    PersistenceProcessorHandler[] getPersistenceProcessorHandler(Provider<PersistenceProcessorHandler> provider) {
        PersistenceProcessorHandler[] persistenceProcessorHandlers = new PersistenceProcessorHandler[this.config.getNumConcurrentCTWriters()];
        for (int i = 0; i < persistenceProcessorHandlers.length; ++i) {
            persistenceProcessorHandlers[i] = (PersistenceProcessorHandler)provider.get();
        }
        return persistenceProcessorHandlers;
    }
}

