/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.pool2.ObjectPool;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.BatchPoolModule;
import org.apache.omid.tso.TSOServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestBatchPool {
    private static final Logger LOG = LoggerFactory.getLogger(TestBatchPool.class);
    private static final int CONCURRENT_WRITERS = 16;
    private static final int BATCH_SIZE = 1000;
    private Injector injector;

    @BeforeMethod
    void setup() {
        TSOServerConfig tsoServerConfig = new TSOServerConfig();
        tsoServerConfig.setNumConcurrentCTWriters(16);
        tsoServerConfig.setBatchSizePerCTWriter(1000);
        this.injector = Guice.createInjector((Module[])new Module[]{new BatchPoolModule(tsoServerConfig)});
    }

    @Test(timeOut=10000L)
    public void testBatchPoolObtainedIsSingleton() {
        ObjectPool instance1 = (ObjectPool)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ObjectPool<Batch>>(){}));
        ObjectPool instance2 = (ObjectPool)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ObjectPool<Batch>>(){}));
        Assert.assertEquals((Object)instance1, (Object)instance2, (String)"Objects are NOT equal !");
    }

    @Test(timeOut=10000L)
    public void testBatchPoolInitializesAllBatchObjectsAsIdle() throws Exception {
        ObjectPool batchPool = (ObjectPool)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ObjectPool<Batch>>(){}));
        Assert.assertEquals((int)batchPool.getNumActive(), (int)0);
        Assert.assertEquals((int)batchPool.getNumIdle(), (int)16);
        for (int i = 0; i < 16; ++i) {
            batchPool.borrowObject();
        }
        Assert.assertEquals((int)batchPool.getNumActive(), (int)16);
        Assert.assertEquals((int)batchPool.getNumIdle(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void testBatchPoolBlocksWhenAllObjectsAreActive() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        final ObjectPool batchPool = (ObjectPool)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ObjectPool<Batch>>(){}));
        for (int i = 0; i < 17; ++i) {
            Callable<Batch> task = new Callable<Batch>(){

                @Override
                public Batch call() throws Exception {
                    return (Batch)batchPool.borrowObject();
                }
            };
            Future<Batch> future = executor.submit(task);
            try {
                Batch batch = future.get(1L, TimeUnit.SECONDS);
                LOG.info("Batch {} returned with success", (Object)batch.toString());
                continue;
            }
            catch (TimeoutException ex) {
                if (i < 16) {
                    Assert.fail();
                    continue;
                }
                LOG.info("Yaaaayyyyy! This is the blocked call!");
                continue;
            }
            finally {
                future.cancel(true);
            }
        }
    }
}

