/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.omid.TestUtils;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.TSOMockModule;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.CellId;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.apache.omid.tso.util.DummyCellIdImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIntegrationOfTSOClientServerBasicFunctionality {
    private static final Logger LOG = LoggerFactory.getLogger(TestIntegrationOfTSOClientServerBasicFunctionality.class);
    private static final String TSO_SERVER_HOST = "localhost";
    private int tsoServerPortForTest;
    private static final CellId c1 = new DummyCellIdImpl(3735928559L);
    private static final CellId c2 = new DummyCellIdImpl(4276996862L);
    private TSOServer tsoServer;
    private TSOClient tsoClient;
    private TSOClient justAnotherTSOClient;
    private CommitTable.Client commitTableClient;
    private LowWatermarkWriter lowWatermarkWriter;

    @BeforeClass
    public void setup() throws Exception {
        this.tsoServerPortForTest = TestUtils.getFreeLocalPort();
        TSOServerConfig tsoConfig = new TSOServerConfig();
        tsoConfig.setConflictMapSize(1000);
        tsoConfig.setPort(this.tsoServerPortForTest);
        TSOMockModule tsoServerMockModule = new TSOMockModule(tsoConfig);
        Injector injector = Guice.createInjector((Module[])new Module[]{tsoServerMockModule});
        this.lowWatermarkWriter = (LowWatermarkWriter)injector.getInstance(LowWatermarkWriter.class);
        CommitTable commitTable = (CommitTable)injector.getInstance(CommitTable.class);
        this.commitTableClient = commitTable.getClient();
        LOG.info("==================================================================================================");
        LOG.info("======================================= Init TSO Server ==========================================");
        LOG.info("==================================================================================================");
        this.tsoServer = (TSOServer)injector.getInstance(TSOServer.class);
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
        TestUtils.waitForSocketListening(TSO_SERVER_HOST, this.tsoServerPortForTest, 100);
        LOG.info("==================================================================================================");
        LOG.info("===================================== TSO Server Initialized =====================================");
        LOG.info("==================================================================================================");
        LOG.info("==================================================================================================");
        LOG.info("======================================= Setup TSO Clients ========================================");
        LOG.info("==================================================================================================");
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:" + this.tsoServerPortForTest);
        this.tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        this.justAnotherTSOClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
        LOG.info("==================================================================================================");
        LOG.info("===================================== TSO Clients Initialized ====================================");
        LOG.info("==================================================================================================");
        Thread.currentThread().setName("Test Thread");
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.tsoClient.close().get();
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
        this.tsoServer = null;
        TestUtils.waitForSocketNotListening(TSO_SERVER_HOST, this.tsoServerPortForTest, 1000);
    }

    @Test(timeOut=30000L)
    public void testTimestampsOrderingGrowMonotonically() throws Exception {
        long startTsTx1;
        long referenceTimestamp = startTsTx1 = ((Long)this.tsoClient.getNewStartTimestamp().get()).longValue();
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((startTsTx2 >= (referenceTimestamp += 50L) ? 1 : 0) != 0, (String)"Should grow monotonically");
        Assert.assertTrue((startTsTx2 > startTsTx1 ? 1 : 0) != 0, (String)"Two timestamps obtained consecutively should grow");
        long commitTsTx2 = (Long)this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((commitTsTx2 >= (referenceTimestamp += 50L) ? 1 : 0) != 0, (String)"Should grow monotonically");
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c2})).get();
        Assert.assertTrue((commitTsTx1 >= (referenceTimestamp += 50L) ? 1 : 0) != 0, (String)"Should grow monotonically");
        long startTsTx3 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((startTsTx3 >= (referenceTimestamp += 50L) ? 1 : 0) != 0, (String)"Should grow monotonically");
    }

    @Test(timeOut=30000L)
    public void testSimpleTransactionWithNoWriteSetCanCommit() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet()).get();
        Assert.assertTrue((commitTsTx1 > startTsTx1 ? 1 : 0) != 0);
    }

    @Test(timeOut=30000L)
    public void testTransactionWithMassiveWriteSetCanCommit() throws Exception {
        long startTs = (Long)this.tsoClient.getNewStartTimestamp().get();
        HashSet<DummyCellIdImpl> cells = new HashSet<DummyCellIdImpl>();
        for (int i = 0; i < 1000000; ++i) {
            cells.add(new DummyCellIdImpl((long)i));
        }
        long commitTs = (Long)this.tsoClient.commit(startTs, cells).get();
        Assert.assertTrue((commitTs > startTs ? 1 : 0) != 0, (String)"Commit TS should be higher than Start TS");
    }

    @Test(timeOut=30000L)
    public void testMultipleSerialCommitsDoNotConflict() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((commitTsTx1 > startTsTx1 ? 1 : 0) != 0, (String)"Commit TS must be greater than Start TS");
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((startTsTx2 > commitTsTx1 ? 1 : 0) != 0, (String)"TS should grow monotonically");
        long commitTsTx2 = (Long)this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        Assert.assertTrue((commitTsTx2 > startTsTx2 ? 1 : 0) != 0, (String)"Commit TS must be greater than Start TS");
        long startTsTx3 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long commitTsTx3 = (Long)this.tsoClient.commit(startTsTx3, (Set)Sets.newHashSet((Object[])new CellId[]{c2})).get();
        Assert.assertTrue((commitTsTx3 > startTsTx3 ? 1 : 0) != 0, (String)"Commit TS must be greater than Start TS");
    }

    @Test(timeOut=30000L)
    public void testCommitWritesToCommitTable() throws Exception {
        long commitTsForTx1;
        long startTsForTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsForTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((startTsForTx2 > startTsForTx1 ? 1 : 0) != 0, (String)"Start TS should grow");
        if (!this.tsoClient.isLowLatency()) {
            Assert.assertFalse((boolean)((Optional)this.commitTableClient.getCommitTimestamp(startTsForTx1).get()).isPresent(), (String)"Commit TS for Tx1 shouldn't appear in Commit Table");
        }
        Assert.assertTrue(((commitTsForTx1 = ((Long)this.tsoClient.commit(startTsForTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get()).longValue()) > startTsForTx1 ? 1 : 0) != 0, (String)"Commit TS should be higher than Start TS for the same tx");
        if (!this.tsoClient.isLowLatency()) {
            Long commitTs1InCommitTable = ((CommitTable.CommitTimestamp)((Optional)this.commitTableClient.getCommitTimestamp(startTsForTx1).get()).get()).getValue();
            Assert.assertNotNull((Object)commitTs1InCommitTable, (String)"Tx is committed, should return as such from Commit Table");
            Assert.assertEquals((long)commitTsForTx1, (long)commitTs1InCommitTable, (String)"getCommitTimestamp() & commit() should report same Commit TS value for same tx");
            Assert.assertTrue((commitTs1InCommitTable > startTsForTx2 ? 1 : 0) != 0, (String)"Commit TS should be higher than tx's Start TS");
        } else {
            Assert.assertTrue((commitTsForTx1 > startTsForTx2 ? 1 : 0) != 0, (String)"Commit TS should be higher than tx's Start TS");
        }
    }

    @Test(timeOut=30000L)
    public void testTwoConcurrentTxWithOverlappingWritesetsHaveConflicts() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx2 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertTrue((startTsTx2 > startTsTx1 ? 1 : 0) != 0, (String)"Second TX should have higher TS");
        long commitTsTx1 = (Long)this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        Assert.assertTrue((commitTsTx1 > startTsTx1 ? 1 : 0) != 0, (String)"Commit TS must be higher than Start TS for the same tx");
        try {
            this.tsoClient.commit(startTsTx2, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"Second TX should fail on commit");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(AbortException.class, ee.getCause().getClass(), (String)"Should have aborted");
        }
    }

    @Test(timeOut=30000L)
    public void testTransactionStartedBeforeFenceAborts() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long fenceID = (Long)this.tsoClient.getFence(c1.getTableId()).get();
        Assert.assertTrue((fenceID > startTsTx1 ? 1 : 0) != 0, (String)"Fence ID should be higher thank Tx1ID");
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"TX should fail on commit");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(AbortException.class, ee.getCause().getClass(), (String)"Should have aborted");
        }
    }

    @Test(timeOut=30000L)
    public void testTransactionStartedBeforeNonOverlapFenceCommits() throws Exception {
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        this.tsoClient.getFence(7L).get();
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        }
        catch (ExecutionException ee) {
            Assert.fail((String)"TX should successfully commit");
        }
    }

    @Test(timeOut=30000L)
    public void testTransactionStartedAfterFenceCommits() throws Exception {
        this.tsoClient.getFence(c1.getTableId()).get();
        long startTsTx1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        try {
            this.tsoClient.commit(startTsTx1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
        }
        catch (ExecutionException ee) {
            Assert.fail((String)"TX should successfully commit");
        }
    }

    @Test(timeOut=30000L)
    public void testConflictsAndMonotonicallyTimestampGrowthWithTwoDifferentTSOClients() throws Exception {
        long startTsTx1Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx2Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        long startTsTx3Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        Long commitTSTx1 = (Long)this.tsoClient.commit(startTsTx1Client1, (Set)Sets.newHashSet((Object[])new CellId[]{c1})).get();
        try {
            this.tsoClient.commit(startTsTx3Client1, (Set)Sets.newHashSet((Object[])new CellId[]{c1, c2})).get();
            Assert.fail((String)"Second commit should fail as conflicts with the previous concurrent one");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(AbortException.class, ee.getCause().getClass(), (String)"Should have aborted");
        }
        long startTsTx4Client2 = (Long)this.justAnotherTSOClient.getNewStartTimestamp().get();
        Assert.assertFalse((boolean)((Optional)this.commitTableClient.getCommitTimestamp(startTsTx3Client1).get()).isPresent(), (String)"Tx3 didn't commit");
        if (!this.tsoClient.isLowLatency()) {
            commitTSTx1 = ((CommitTable.CommitTimestamp)((Optional)this.commitTableClient.getCommitTimestamp(startTsTx1Client1).get()).get()).getValue();
        }
        Assert.assertTrue((commitTSTx1 > startTsTx2Client1 ? 1 : 0) != 0, (String)"Tx1 committed after Tx2 started");
        Assert.assertTrue((commitTSTx1 < startTsTx4Client2 ? 1 : 0) != 0, (String)"Tx1 committed before Tx4 started on the other TSO Client");
    }

    @Test(timeOut=30000L)
    public void testLowWaterMarksgetAdvanced() throws ExecutionException, InterruptedException {
        long startTsTx1Client1 = (Long)this.tsoClient.getNewStartTimestamp().get();
        HashSet<DummyCellIdImpl> ws = new HashSet<DummyCellIdImpl>();
        for (int i = 0; i < 32000; ++i) {
            ws.add(new DummyCellIdImpl((long)i));
        }
        Long beforeCommitLWM = (Long)this.commitTableClient.readLowWatermark().get();
        Long commitTSTx1 = (Long)this.tsoClient.commit(startTsTx1Client1, ws).get();
        Thread.sleep(300L);
        Long afterCommitLWM = (Long)this.commitTableClient.readLowWatermark().get();
        assert (afterCommitLWM > beforeCommitLWM);
    }
}

