/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import org.apache.omid.tso.MonitoringContext;
import org.apache.phoenix.thirdparty.com.google.common.base.MoreObjects;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.jboss.netty.channel.Channel;

public final class PersistEvent {
    private MonitoringContext monCtx;
    private Type type = null;
    private Channel channel = null;
    private long startTimestamp = 0L;
    private long commitTimestamp = 0L;
    private Optional<Long> newLowWatermark;

    void makePersistCommit(long startTimestamp, long commitTimestamp, Optional<Long> newLowWatermark, Channel c, MonitoringContext monCtx) {
        this.type = Type.COMMIT;
        this.startTimestamp = startTimestamp;
        this.commitTimestamp = commitTimestamp;
        this.channel = c;
        this.monCtx = monCtx;
        this.newLowWatermark = newLowWatermark;
    }

    void makeCommitRetry(long startTimestamp, Channel c, MonitoringContext monCtx) {
        this.type = Type.COMMIT_RETRY;
        this.startTimestamp = startTimestamp;
        this.channel = c;
        this.monCtx = monCtx;
    }

    void makePersistAbort(long startTimestamp, Channel c, MonitoringContext monCtx) {
        this.type = Type.ABORT;
        this.startTimestamp = startTimestamp;
        this.channel = c;
        this.monCtx = monCtx;
    }

    void makePersistTimestamp(long startTimestamp, Channel c, MonitoringContext monCtx) {
        this.type = Type.TIMESTAMP;
        this.startTimestamp = startTimestamp;
        this.channel = c;
        this.monCtx = monCtx;
    }

    void makePersistFence(long tableID, long fenceTimestamp, Channel c, MonitoringContext monCtx) {
        this.type = Type.FENCE;
        this.startTimestamp = tableID;
        this.commitTimestamp = fenceTimestamp;
        this.channel = c;
        this.monCtx = monCtx;
    }

    MonitoringContext getMonCtx() {
        return this.monCtx;
    }

    Type getType() {
        return this.type;
    }

    Channel getChannel() {
        return this.channel;
    }

    long getStartTimestamp() {
        return this.startTimestamp;
    }

    long getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public Optional<Long> getNewLowWatermark() {
        return this.newLowWatermark;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("ST", this.startTimestamp).add("CT", this.commitTimestamp).toString();
    }

    static enum Type {
        TIMESTAMP,
        COMMIT,
        ABORT,
        COMMIT_RETRY,
        FENCE;

    }
}

