/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.omid.tso.TSOServer;
import org.apache.omid.tso.TSOServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsoServerDaemon
implements Daemon {
    private static final Logger LOG = LoggerFactory.getLogger(TsoServerDaemon.class);
    private TSOServer tsoServer;

    public void init(DaemonContext daemonContext) throws Exception {
        try {
            TSOServerConfig config = new TSOServerConfig();
            LOG.info("Creating TSOServer instance as a Daemon process...");
            this.tsoServer = TSOServer.getInitializedTsoServer(config);
            LOG.info("TSOServer instance for Daemon process created");
        }
        catch (Exception e) {
            LOG.error("Error creating TSOServer instance", (Throwable)e);
            throw e;
        }
    }

    public void start() throws Exception {
        this.tsoServer.startAsync();
        this.tsoServer.awaitRunning();
    }

    public void stop() throws Exception {
        this.tsoServer.stopAsync();
        this.tsoServer.awaitTerminated();
    }

    public void destroy() {
    }
}

