/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.NullMetricsProvider;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.MockPanicker;
import org.apache.omid.tso.MonitoringContext;
import org.apache.omid.tso.MonitoringContextImpl;
import org.apache.omid.tso.Panicker;
import org.apache.omid.tso.PersistenceProcessor;
import org.apache.omid.tso.ReplyProcessor;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.RequestProcessorPersistCT;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.TSOStateManagerImpl;
import org.apache.omid.tso.TimestampOracle;
import org.apache.omid.tso.TimestampOracleImpl;
import org.apache.phoenix.thirdparty.com.google.common.base.Optional;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.SettableFuture;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestRequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TestRequestProcessor.class);
    private static final int CONFLICT_MAP_SIZE = 1000;
    private static final int CONFLICT_MAP_ASSOCIATIVITY = 32;
    private MetricsRegistry metrics = new NullMetricsProvider();
    private PersistenceProcessor persist;
    private TSOStateManager stateManager;
    private RequestProcessor requestProc;
    private LowWatermarkWriter lowWatermarkWriter;
    private TimestampOracleImpl timestampOracle;
    private ReplyProcessor replyProcessor;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        NullMetricsProvider metrics = new NullMetricsProvider();
        TimestampOracleImpl timestampOracle = new TimestampOracleImpl((MetricsRegistry)metrics, (TimestampStorage)new TimestampOracleImpl.InMemoryTimestampStorage(), (Panicker)new MockPanicker());
        this.stateManager = new TSOStateManagerImpl((TimestampOracle)timestampOracle);
        this.lowWatermarkWriter = (LowWatermarkWriter)Mockito.mock(LowWatermarkWriter.class);
        this.persist = (PersistenceProcessor)Mockito.mock(PersistenceProcessor.class);
        this.replyProcessor = (ReplyProcessor)Mockito.mock(ReplyProcessor.class);
        SettableFuture f = SettableFuture.create();
        f.set(null);
        ((LowWatermarkWriter)Mockito.doReturn((Object)f).when((Object)this.lowWatermarkWriter)).persistLowWatermark(((Long)ArgumentMatchers.any(Long.class)).longValue());
        TSOServerConfig config = new TSOServerConfig();
        config.setConflictMapSize(1000);
        this.requestProc = new RequestProcessorPersistCT((MetricsRegistry)metrics, (TimestampOracle)timestampOracle, this.persist, (Panicker)new MockPanicker(), config, this.lowWatermarkWriter, this.replyProcessor);
        this.stateManager.register((TSOStateManager.StateObserver)this.requestProc);
        this.stateManager.initialize();
    }

    @Test(timeOut=30000L)
    public void testTimestamp() throws Exception {
        this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor firstTScapture = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addTimestampToBatch(((Long)firstTScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        long firstTS = (Long)firstTScapture.getValue();
        for (int i = 0; i < 100; ++i) {
            this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
            ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addTimestampToBatch(ArgumentMatchers.eq((long)firstTS), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
            firstTS += 50L;
        }
    }

    @Test(timeOut=30000L)
    public void testCommit() throws Exception {
        this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor TScapture = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addTimestampToBatch(((Long)TScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        long firstTS = (Long)TScapture.getValue();
        ArrayList writeSet = Lists.newArrayList((Object[])new Long[]{1L, 20L, 203L});
        this.requestProc.commitRequest(firstTS - 50L, (Collection)writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addAbortToBatch(ArgumentMatchers.eq((long)(firstTS - 50L)), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        this.requestProc.commitRequest(firstTS, (Collection)writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor commitTScapture = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addCommitToBatch(ArgumentMatchers.eq((long)firstTS), ((Long)commitTScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class), (Optional)ArgumentMatchers.any(Optional.class));
        Assert.assertTrue(((Long)commitTScapture.getValue() > firstTS ? 1 : 0) != 0, (String)"Commit TS must be greater than start TS");
        this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        TScapture = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(2))).addTimestampToBatch(((Long)TScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        long secondTS = (Long)TScapture.getValue();
        this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        TScapture = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(3))).addTimestampToBatch(((Long)TScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        long thirdTS = (Long)TScapture.getValue();
        this.requestProc.commitRequest(thirdTS, (Collection)writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addCommitToBatch(ArgumentMatchers.eq((long)thirdTS), ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class), (Optional)ArgumentMatchers.any(Optional.class));
        this.requestProc.commitRequest(secondTS, (Collection)writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addAbortToBatch(ArgumentMatchers.eq((long)secondTS), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
    }

    @Test(timeOut=30000L)
    public void testFence() {
        this.requestProc.fenceRequest(666L, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor firstTScapture = ArgumentCaptor.forClass(Long.class);
        ((ReplyProcessor)Mockito.verify((Object)this.replyProcessor, (VerificationMode)Mockito.timeout((long)100L).times(1))).sendFenceResponse(ArgumentMatchers.eq((long)666L), ((Long)firstTScapture.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
    }

    @Test(timeOut=30000L)
    public void testCommitRequestAbortsWhenResettingRequestProcessorState() throws Exception {
        List writeSet = Collections.emptyList();
        this.requestProc.timestampRequest(null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ArgumentCaptor capturedTS = ArgumentCaptor.forClass(Long.class);
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addTimestampToBatch(((Long)capturedTS.capture()).longValue(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
        long startTS = (Long)capturedTS.getValue();
        this.stateManager.initialize();
        this.requestProc.commitRequest(startTS, writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addAbortToBatch(ArgumentMatchers.eq((long)startTS), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class));
    }

    @Test(timeOut=5000L)
    public void testLowWaterIsForwardedWhenACacheElementIsEvicted() throws Exception {
        long ANY_START_TS = 1L;
        long FIRST_COMMIT_TS_EVICTED = 50L;
        long NEXT_COMMIT_TS_THAT_SHOULD_BE_EVICTED = 100L;
        for (long i = 0L; i < 1032L; ++i) {
            long writeSetElementHash = i + 1L;
            ArrayList writeSet = Lists.newArrayList((Object[])new Long[]{writeSetElementHash});
            this.requestProc.commitRequest(1L, (Collection)writeSet, new ArrayList(0), false, null, (MonitoringContext)new MonitoringContextImpl(this.metrics));
        }
        Thread.sleep(3000L);
        ((LowWatermarkWriter)Mockito.verify((Object)this.lowWatermarkWriter, (VerificationMode)Mockito.timeout((long)100L).times(1))).persistLowWatermark(ArgumentMatchers.eq((long)0L));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(1))).addCommitToBatch(ArgumentMatchers.eq((long)1L), ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class), (Optional)ArgumentMatchers.eq((Object)Optional.of((Object)50L)));
        ((PersistenceProcessor)Mockito.verify((Object)this.persist, (VerificationMode)Mockito.timeout((long)100L).times(0))).addCommitToBatch(ArgumentMatchers.eq((long)1L), ArgumentMatchers.anyLong(), (Channel)ArgumentMatchers.any(), (MonitoringContext)ArgumentMatchers.any(MonitoringContext.class), (Optional)ArgumentMatchers.eq((Object)Optional.of((Object)100L)));
    }
}

