/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Module;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.omid.NetworkUtils;
import org.apache.omid.tso.HALeaseManagementModule;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.net.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkInterfaceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkInterfaceUtils.class);

    static InetAddress getIPAddressFromNetworkInterface(String ifaceName) throws SocketException, UnknownHostException {
        NetworkInterface iface = NetworkInterface.getByName(ifaceName);
        if (iface == null) {
            throw new IllegalArgumentException("Network interface " + ifaceName + " not found");
        }
        InetAddress candidateAddress = null;
        Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
        while (inetAddrs.hasMoreElements()) {
            InetAddress inetAddr = inetAddrs.nextElement();
            if (inetAddr.isLoopbackAddress()) continue;
            if (inetAddr.isSiteLocalAddress()) {
                return inetAddr;
            }
            if (candidateAddress != null) continue;
            candidateAddress = inetAddr;
        }
        if (candidateAddress != null) {
            return candidateAddress;
        }
        InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
        if (jdkSuppliedAddress == null) {
            throw new UnknownHostException("InetAddress.getLocalHost() unexpectedly returned null.");
        }
        return jdkSuppliedAddress;
    }

    public static String getTSOHostAndPort(TSOServerConfig config) throws SocketException, UnknownHostException {
        if (config.getNetworkIfaceName() == null) {
            try {
                return NetworkInterfaceUtils.getTSOHostAndPortRelativeToZK(config);
            }
            catch (Exception e) {
                LOG.info("Could not determine local address relative to ZK server", (Throwable)e);
            }
        }
        return NetworkInterfaceUtils.getTSOHostAndPortFromInterface(config);
    }

    public static String getTSOHostAndPortFromInterface(TSOServerConfig config) throws SocketException, UnknownHostException {
        String tsoNetIfaceName = config.getNetworkIfaceName();
        if (tsoNetIfaceName == null) {
            tsoNetIfaceName = NetworkUtils.getDefaultNetworkInterface();
        }
        InetAddress addr = NetworkInterfaceUtils.getIPAddressFromNetworkInterface(tsoNetIfaceName);
        int tsoPort = config.getPort();
        String tsoHostAndPortAsString = "N/A";
        try {
            tsoHostAndPortAsString = HostAndPort.fromParts((String)addr.getHostAddress(), (int)tsoPort).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Cannot parse TSO host:port string {}", (Object)tsoHostAndPortAsString);
            throw e;
        }
        return tsoHostAndPortAsString;
    }

    public static String getTSOHostAndPortRelativeToZK(TSOServerConfig config) throws Exception {
        Module leaseModule = config.getLeaseModule();
        if (leaseModule instanceof HALeaseManagementModule) {
            LOG.info("HA is configured. Trying to determine local address facing ZK server");
            String zkQuorum = ((HALeaseManagementModule)leaseModule).getZkCluster();
            String firstHost = zkQuorum.split(",")[0];
            LOG.info("ZK quorum is {}, first server is {}", (Object)zkQuorum, (Object)firstHost);
            HostAndPort hostAndPort = HostAndPort.fromString((String)firstHost);
            Socket socket = new Socket(hostAndPort.getHost(), hostAndPort.getPort());
            InetAddress addr = socket.getLocalAddress();
            socket.close();
            LOG.info("Local address facing ZK server is {}", (Object)addr);
            return HostAndPort.fromParts((String)addr.getHostAddress(), (int)config.getPort()).toString();
        }
        throw new Exception("HA is not configured");
    }
}

