/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.protobuf.MessageLite;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.ssl.OptionalSslHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tls.X509Exception;
import org.apache.omid.tls.X509Util;
import org.apache.omid.tso.MonitoringContextFactory;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class TSOChannelHandler
extends ChannelInboundHandlerAdapter
implements Closeable {
    private final Logger LOG = LoggerFactory.getLogger(TSOChannelHandler.class);
    private final ServerBootstrap bootstrap;
    @VisibleForTesting
    Channel listeningChannel;
    @VisibleForTesting
    ChannelGroup allChannels;
    private RequestProcessor requestProcessor;
    private TSOServerConfig config;
    private MetricsRegistry metrics;
    private static final AttributeKey<TSOChannelContext> TSO_CTX = AttributeKey.valueOf((String)"TSO_CTX");

    @Inject
    public TSOChannelHandler(final TSOServerConfig config, RequestProcessor requestProcessor, MetricsRegistry metrics) {
        this.config = config;
        this.metrics = metrics;
        this.requestProcessor = requestProcessor;
        int workerThreadCount = (Runtime.getRuntime().availableProcessors() * 2 + 1) * 2;
        ThreadFactory bossThreadFactory = new ThreadFactoryBuilder().setNameFormat("tsoserver-boss-%d").build();
        ThreadFactory workerThreadFactory = new ThreadFactoryBuilder().setNameFormat("tsoserver-worker-%d").build();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(workerThreadCount, workerThreadFactory);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(bossThreadFactory);
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
        this.bootstrap.channel(NioServerSocketChannel.class);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (config.getTlsEnabled()) {
                    TSOChannelHandler.this.initSSL(pipeline, config.getSupportPlainText());
                }
                pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0xA00000, 0, 4, 0, 4));
                pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("protobufdecoder", (ChannelHandler)new ProtobufDecoder((MessageLite)TSOProto.Request.getDefaultInstance()));
                pipeline.addLast("protobufencoder", (ChannelHandler)new ProtobufEncoder());
                pipeline.addLast("handler", (ChannelHandler)TSOChannelHandler.this);
            }
        });
    }

    private void initSSL(ChannelPipeline p, boolean supportPlaintext) throws X509Exception, IOException {
        String keyStoreLocation = this.config.getKeyStoreLocation();
        char[] keyStorePassword = this.config.getKeyStorePassword().toCharArray();
        String keyStoreType = this.config.getKeyStoreType();
        String trustStoreLocation = this.config.getTrustStoreLocation();
        char[] truststorePassword = this.config.getTrustStorePassword().toCharArray();
        String truststoreType = this.config.getTrustStoreType();
        boolean sslCrlEnabled = this.config.getSslCrlEnabled();
        boolean sslOcspEnabled = this.config.getSslOcspEnabled();
        String enabledProtocols = this.config.getEnabledProtocols();
        String cipherSuites = this.config.getCipherSuites();
        String tlsConfigProtocols = this.config.getTsConfigProtocols();
        SslContext nettySslContext = X509Util.createSslContextForServer((String)keyStoreLocation, (char[])keyStorePassword, (String)keyStoreType, (String)trustStoreLocation, (char[])truststorePassword, (String)truststoreType, (boolean)sslCrlEnabled, (boolean)sslOcspEnabled, (String)enabledProtocols, (String)cipherSuites, (String)tlsConfigProtocols);
        if (supportPlaintext) {
            p.addLast("ssl", (ChannelHandler)new OptionalSslHandler(nettySslContext));
            this.LOG.info("Dual mode SSL handler added for channel: {}", (Object)p.channel());
        } else {
            p.addLast("ssl", (ChannelHandler)nettySslContext.newHandler(p.channel().alloc()));
            this.LOG.info("SSL handler added for channel: {}", (Object)p.channel());
        }
    }

    void reconnect() {
        if (this.listeningChannel == null && this.allChannels == null) {
            this.LOG.debug("Creating communication channel...");
        } else {
            this.LOG.debug("Reconnecting communication channel...");
            this.closeConnection();
        }
        this.allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.LOG.debug("\tCreating channel to listening for incoming connections in port {}", (Object)this.config.getPort());
        this.listeningChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.config.getPort())).syncUninterruptibly().channel();
        this.allChannels.add((Object)this.listeningChannel);
        this.LOG.debug("\tListening channel created and connected: {}", (Object)this.listeningChannel);
    }

    void closeConnection() {
        this.LOG.debug("Closing communication channel...");
        if (this.allChannels != null) {
            this.LOG.debug("\tClosing channel group {}", (Object)this.allChannels);
            this.allChannels.close().awaitUninterruptibly();
            this.LOG.debug("\tChannel group {} closed", (Object)this.allChannels);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.allChannels.add((Object)ctx.channel());
        this.LOG.debug("TSO channel active: {}", (Object)ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.LOG.debug("TSO channel inactive: {}", (Object)ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof TSOProto.Request) {
            TSOProto.Request request = (TSOProto.Request)msg;
            if (request.hasHandshakeRequest()) {
                this.checkHandshake(ctx, request.getHandshakeRequest());
                return;
            }
            if (!this.handshakeCompleted(ctx)) {
                this.LOG.error("Handshake not completed. Closing channel {}", (Object)ctx.channel());
                ctx.channel().close();
            }
            if (request.hasTimestampRequest()) {
                this.requestProcessor.timestampRequest(ctx.channel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else if (request.hasCommitRequest()) {
                TSOProto.CommitRequest cr = request.getCommitRequest();
                this.requestProcessor.commitRequest(cr.getStartTimestamp(), cr.getCellIdList(), cr.getTableIdList(), cr.getIsRetry(), ctx.channel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else if (request.hasFenceRequest()) {
                TSOProto.FenceRequest fr = request.getFenceRequest();
                this.requestProcessor.fenceRequest(fr.getTableId(), ctx.channel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else {
                this.LOG.error("Invalid request {}. Closing channel {}", (Object)request, (Object)ctx.channel());
                ctx.channel().close();
            }
        } else {
            this.LOG.error("Unknown message type", msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof ClosedChannelException) {
            this.LOG.warn("ClosedChannelException caught. Cause: ", cause);
            return;
        }
        this.LOG.warn("Unexpected exception. Closing channel {}", (Object)ctx.channel(), (Object)cause);
        ctx.channel().close();
    }

    @Override
    public void close() throws IOException {
        this.LOG.debug("Shutting down communication channel...");
        this.bootstrap.config().group().shutdownGracefully();
        this.bootstrap.config().childGroup().shutdownGracefully();
        this.bootstrap.config().group().terminationFuture().awaitUninterruptibly();
        this.bootstrap.config().childGroup().terminationFuture().awaitUninterruptibly();
    }

    private void checkHandshake(ChannelHandlerContext ctx, TSOProto.HandshakeRequest request) {
        TSOProto.HandshakeResponse.Builder response = TSOProto.HandshakeResponse.newBuilder();
        if (request.hasClientCapabilities()) {
            response.setClientCompatible(true).setServerCapabilities(TSOProto.Capabilities.newBuilder().build());
            TSOChannelContext tsoCtx = new TSOChannelContext();
            tsoCtx.setHandshakeComplete();
            ctx.channel().attr(TSO_CTX).set((Object)tsoCtx);
        } else {
            response.setClientCompatible(false);
        }
        response.setLowLatency(this.config.getLowLatency().booleanValue());
        ctx.channel().writeAndFlush((Object)TSOProto.Response.newBuilder().setHandshakeResponse(response.build()).build());
    }

    private boolean handshakeCompleted(ChannelHandlerContext ctx) {
        TSOChannelContext tsoCtx = (TSOChannelContext)ctx.channel().attr(TSO_CTX).get();
        if (tsoCtx != null) {
            return tsoCtx.getHandshakeComplete();
        }
        return false;
    }

    private static class TSOChannelContext {
        boolean handshakeComplete = false;

        TSOChannelContext() {
        }

        boolean getHandshakeComplete() {
            return this.handshakeComplete;
        }

        void setHandshakeComplete() {
            this.handshakeComplete = true;
        }
    }
}

