/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Hive2Action;
import org.apache.oozie.fluentjob.api.action.HiveActionBuilder;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Hive2ActionBuilder
extends NodeBuilderBaseImpl<Hive2ActionBuilder>
implements Builder<Hive2Action> {
    private final HiveActionBuilder delegate;
    private final ModifyOnce<String> jdbcUrl;
    private final ModifyOnce<String> password;

    public static Hive2ActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> jdbcUrl = new ModifyOnce<String>();
        ModifyOnce<String> password = new ModifyOnce<String>();
        ModifyOnce<String> script = new ModifyOnce<String>();
        ModifyOnce<String> query = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new Hive2ActionBuilder(null, builder, jdbcUrl, password, script, query, params);
    }

    public static Hive2ActionBuilder createFromExistingAction(Hive2Action action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> jdbcUrl = new ModifyOnce<String>(action.getJdbcUrl());
        ModifyOnce<String> password = new ModifyOnce<String>(action.getPassword());
        ModifyOnce<String> script = new ModifyOnce<String>(action.getScript());
        ModifyOnce<String> query = new ModifyOnce<String>(action.getQuery());
        ArrayList<String> params = new ArrayList<String>(action.getParams());
        return new Hive2ActionBuilder(action, builder, jdbcUrl, password, script, query, params);
    }

    public static Hive2ActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> jdbcUrl = new ModifyOnce<String>();
        ModifyOnce<String> password = new ModifyOnce<String>();
        ModifyOnce<String> script = new ModifyOnce<String>();
        ModifyOnce<String> query = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new Hive2ActionBuilder(action, builder, jdbcUrl, password, script, query, params);
    }

    Hive2ActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> jdbcUrl, ModifyOnce<String> password, ModifyOnce<String> script, ModifyOnce<String> query, List<String> params) {
        super(action);
        this.delegate = new HiveActionBuilder(action, attributesBuilder, script, query, params);
        this.jdbcUrl = jdbcUrl;
        this.password = password;
    }

    public Hive2ActionBuilder withResourceManager(String resourceManager) {
        this.delegate.withResourceManager(resourceManager);
        return this;
    }

    public Hive2ActionBuilder withNameNode(String nameNode) {
        this.delegate.withNameNode(nameNode);
        return this;
    }

    public Hive2ActionBuilder withPrepare(Prepare prepare) {
        this.delegate.withPrepare(prepare);
        return this;
    }

    public Hive2ActionBuilder withLauncher(Launcher launcher) {
        this.delegate.withLauncher(launcher);
        return this;
    }

    public Hive2ActionBuilder withJobXml(String jobXml) {
        this.delegate.withJobXml(jobXml);
        return this;
    }

    public Hive2ActionBuilder withoutJobXml(String jobXml) {
        this.delegate.withoutJobXml(jobXml);
        return this;
    }

    public Hive2ActionBuilder clearJobXmls() {
        this.delegate.clearJobXmls();
        return this;
    }

    public Hive2ActionBuilder withConfigProperty(String key, String value) {
        this.delegate.withConfigProperty(key, value);
        return this;
    }

    public Hive2ActionBuilder withScript(String script) {
        this.delegate.withScript(script);
        return this;
    }

    public Hive2ActionBuilder withQuery(String query) {
        this.delegate.withQuery(query);
        return this;
    }

    public Hive2ActionBuilder withParam(String param) {
        this.delegate.withParam(param);
        return this;
    }

    public Hive2ActionBuilder withoutParam(String param) {
        this.delegate.withoutParam(param);
        return this;
    }

    public Hive2ActionBuilder clearParams() {
        this.delegate.clearParams();
        return this;
    }

    public Hive2ActionBuilder withArg(String arg) {
        this.delegate.withArg(arg);
        return this;
    }

    public Hive2ActionBuilder withoutArg(String arg) {
        this.delegate.withoutArg(arg);
        return this;
    }

    public Hive2ActionBuilder clearArgs() {
        this.delegate.clearArgs();
        return this;
    }

    public Hive2ActionBuilder withFile(String file) {
        this.delegate.withFile(file);
        return this;
    }

    public Hive2ActionBuilder withoutFile(String file) {
        this.delegate.withoutFile(file);
        return this;
    }

    public Hive2ActionBuilder clearFiles() {
        this.delegate.clearFiles();
        return this;
    }

    public Hive2ActionBuilder withArchive(String archive) {
        this.delegate.withArchive(archive);
        return this;
    }

    public Hive2ActionBuilder withoutArchive(String archive) {
        this.delegate.withoutArchive(archive);
        return this;
    }

    public Hive2ActionBuilder clearArchives() {
        this.delegate.clearArchives();
        return this;
    }

    public Hive2ActionBuilder withJdbcUrl(String jdbcUrl) {
        this.jdbcUrl.set(jdbcUrl);
        return this;
    }

    public Hive2ActionBuilder withPassword(String password) {
        this.password.set(password);
        return this;
    }

    @Override
    public Hive2Action build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        Hive2Action instance = new Hive2Action(constructionData, this.delegate.getAttributesBuilder().build(), this.jdbcUrl.get(), this.password.get(), this.delegate.getScript().get(), this.delegate.query.get(), (ImmutableList<String>)ImmutableList.copyOf(this.delegate.getParams()));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected Hive2ActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

