/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.PigAction;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PigActionBuilder
extends NodeBuilderBaseImpl<PigActionBuilder>
implements Builder<PigAction> {
    protected final ActionAttributesBuilder attributesBuilder;
    protected final ModifyOnce<String> script;
    protected final List<String> params;

    public static PigActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> script = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new PigActionBuilder(null, builder, script, params);
    }

    public static PigActionBuilder createFromExistingAction(PigAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> script = new ModifyOnce<String>(action.getScript());
        ArrayList<String> params = new ArrayList<String>(action.getParams());
        return new PigActionBuilder(action, builder, script, params);
    }

    public static PigActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> script = new ModifyOnce<String>();
        ArrayList<String> params = new ArrayList<String>();
        return new PigActionBuilder(action, builder, script, params);
    }

    PigActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> script, List<String> params) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.script = script;
        this.params = params;
    }

    public PigActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public PigActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public PigActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public PigActionBuilder withLauncher(Launcher launcher) {
        this.attributesBuilder.withLauncher(launcher);
        return this;
    }

    public PigActionBuilder withJobXml(String jobXml) {
        this.attributesBuilder.withJobXml(jobXml);
        return this;
    }

    public PigActionBuilder withoutJobXml(String jobXml) {
        this.attributesBuilder.withoutJobXml(jobXml);
        return this;
    }

    public PigActionBuilder clearJobXmls() {
        this.attributesBuilder.clearJobXmls();
        return this;
    }

    public PigActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public PigActionBuilder withScript(String script) {
        this.script.set(script);
        return this;
    }

    public PigActionBuilder withParam(String param) {
        this.params.add(param);
        return this;
    }

    public PigActionBuilder withoutParam(String param) {
        this.params.remove(param);
        return this;
    }

    public PigActionBuilder clearParams() {
        this.params.clear();
        return this;
    }

    public PigActionBuilder withArg(String arg) {
        this.attributesBuilder.withArg(arg);
        return this;
    }

    public PigActionBuilder withoutArg(String arg) {
        this.attributesBuilder.withoutArg(arg);
        return this;
    }

    public PigActionBuilder clearArgs() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public PigActionBuilder withFile(String file) {
        this.attributesBuilder.withFile(file);
        return this;
    }

    public PigActionBuilder withoutFile(String file) {
        this.attributesBuilder.withoutFile(file);
        return this;
    }

    public PigActionBuilder clearFiles() {
        this.attributesBuilder.clearFiles();
        return this;
    }

    public PigActionBuilder withArchive(String archive) {
        this.attributesBuilder.withArchive(archive);
        return this;
    }

    public PigActionBuilder withoutArchive(String archive) {
        this.attributesBuilder.withoutArchive(archive);
        return this;
    }

    public PigActionBuilder clearArchives() {
        this.attributesBuilder.clearArchives();
        return this;
    }

    @Override
    public PigAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        PigAction instance = new PigAction(constructionData, this.attributesBuilder.build(), this.script.get(), (ImmutableList<String>)ImmutableList.copyOf(this.params));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected PigActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

