/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;
import org.apache.oozie.fluentjob.api.action.ShellAction;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ShellActionBuilder
extends NodeBuilderBaseImpl<ShellActionBuilder>
implements Builder<ShellAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> executable;
    private final List<String> environmentVariables;

    public static ShellActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> executable = new ModifyOnce<String>();
        ArrayList<String> environmentVariables = new ArrayList<String>();
        return new ShellActionBuilder(null, builder, executable, environmentVariables);
    }

    public static ShellActionBuilder createFromExistingAction(ShellAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> executable = new ModifyOnce<String>(action.getExecutable());
        ArrayList<String> environmentVariables = new ArrayList<String>(action.getEnvironmentVariables());
        return new ShellActionBuilder(action, builder, executable, environmentVariables);
    }

    public static ShellActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> executable = new ModifyOnce<String>();
        ArrayList<String> environmentVariables = new ArrayList<String>();
        return new ShellActionBuilder(action, builder, executable, environmentVariables);
    }

    private ShellActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> executable, List<String> environmentVariables) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.executable = executable;
        this.environmentVariables = environmentVariables;
    }

    public ShellActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public ShellActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public ShellActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public ShellActionBuilder withLauncher(Launcher launcher) {
        this.attributesBuilder.withLauncher(launcher);
        return this;
    }

    public ShellActionBuilder withJobXml(String jobXml) {
        this.attributesBuilder.withJobXml(jobXml);
        return this;
    }

    public ShellActionBuilder withoutJobXml(String jobXml) {
        this.attributesBuilder.withoutJobXml(jobXml);
        return this;
    }

    public ShellActionBuilder clearJobXmls() {
        this.attributesBuilder.clearJobXmls();
        return this;
    }

    public ShellActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public ShellActionBuilder withExecutable(String executable) {
        this.executable.set(executable);
        return this;
    }

    public ShellActionBuilder withArgument(String argument) {
        this.attributesBuilder.withArg(argument);
        return this;
    }

    public ShellActionBuilder withoutArgument(String argument) {
        this.attributesBuilder.withoutArg(argument);
        return this;
    }

    public ShellActionBuilder clearArguments() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public ShellActionBuilder withEnvironmentVariable(String environmentVariable) {
        this.environmentVariables.add(environmentVariable);
        return this;
    }

    public ShellActionBuilder withoutEnvironmentVariable(String environmentVariable) {
        this.environmentVariables.remove(environmentVariable);
        return this;
    }

    public ShellActionBuilder clearEnvironmentVariables() {
        this.environmentVariables.clear();
        return this;
    }

    public ShellActionBuilder withFile(String file) {
        this.attributesBuilder.withFile(file);
        return this;
    }

    public ShellActionBuilder withoutFile(String file) {
        this.attributesBuilder.withoutFile(file);
        return this;
    }

    public ShellActionBuilder clearFiles() {
        this.attributesBuilder.clearFiles();
        return this;
    }

    public ShellActionBuilder withArchive(String archive) {
        this.attributesBuilder.withArchive(archive);
        return this;
    }

    public ShellActionBuilder withoutArchive(String archive) {
        this.attributesBuilder.withoutArchive(archive);
        return this;
    }

    public ShellActionBuilder clearArchives() {
        this.attributesBuilder.clearArchives();
        return this;
    }

    public ShellActionBuilder withCaptureOutput(Boolean captureOutput) {
        this.attributesBuilder.withCaptureOutput(captureOutput);
        return this;
    }

    @Override
    public ShellAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        ShellAction instance = new ShellAction(constructionData, this.attributesBuilder.build(), this.executable.get(), (ImmutableList<String>)ImmutableList.copyOf(this.environmentVariables));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected ShellActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

