/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.dag;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.dag.DagNodeWithCondition;
import org.apache.oozie.fluentjob.api.dag.NodeBase;

public class Decision
extends NodeBase {
    private NodeBase parent = null;
    private final List<DagNodeWithCondition> childrenWithConditions = new ArrayList<DagNodeWithCondition>();
    private NodeBase defaultChild;

    public Decision(String name) {
        super(name);
    }

    public NodeBase getParent() {
        return this.parent;
    }

    @Override
    public void addParent(NodeBase parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Decision nodes cannot have multiple parents.");
        this.parent = parent;
        this.parent.addChild(this);
    }

    @Override
    public void addParentWithCondition(Decision parent, Condition condition) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Decision nodes cannot have multiple parents.");
        this.parent = parent;
        parent.addChildWithCondition(this, condition);
    }

    @Override
    public void addParentDefaultConditional(Decision parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Decision nodes cannot have multiple parents.");
        this.parent = parent;
        parent.addDefaultChild(this);
    }

    @Override
    public void removeParent(NodeBase parent) {
        Preconditions.checkArgument((this.parent == parent ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent parent.");
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
    }

    @Override
    public void clearParents() {
        this.removeParent(this.parent);
    }

    @Override
    public List<NodeBase> getChildren() {
        ArrayList<NodeBase> results = new ArrayList<NodeBase>();
        for (DagNodeWithCondition nodeWithCondition : this.getChildrenWithConditions()) {
            results.add(nodeWithCondition.getNode());
        }
        return Collections.unmodifiableList(results);
    }

    public List<DagNodeWithCondition> getChildrenWithConditions() {
        ArrayList<DagNodeWithCondition> results = new ArrayList<DagNodeWithCondition>(this.childrenWithConditions);
        if (this.defaultChild != null) {
            results.add(new DagNodeWithCondition(this.defaultChild, Condition.defaultCondition()));
        }
        return Collections.unmodifiableList(results);
    }

    public NodeBase getDefaultChild() {
        return this.defaultChild;
    }

    @Override
    protected void addChild(NodeBase child) {
        throw new IllegalStateException("Decision nodes cannot have normal children.");
    }

    void addChildWithCondition(NodeBase child, Condition condition) {
        if (condition.isDefault()) {
            this.addDefaultChild(child);
        } else {
            this.childrenWithConditions.add(new DagNodeWithCondition(child, condition));
        }
    }

    void addDefaultChild(NodeBase child) {
        Preconditions.checkState((this.defaultChild == null ? 1 : 0) != 0, (Object)"Trying to add a default child to a Decision node that already has one.");
        this.defaultChild = child;
    }

    @Override
    protected void removeChild(NodeBase child) {
        if (this.defaultChild == child) {
            this.defaultChild = null;
        } else {
            int index = this.indexOfNodeBaseInChildrenWithConditions(child);
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent child.");
            this.childrenWithConditions.remove(index);
        }
    }

    private int indexOfNodeBaseInChildrenWithConditions(NodeBase child) {
        for (int i = 0; i < this.childrenWithConditions.size(); ++i) {
            if (child != this.childrenWithConditions.get(i).getNode()) continue;
            return i;
        }
        return -1;
    }
}

