/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperAware;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.oozie.fluentjob.api.action.ErrorHandler;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.ExplicitNode;
import org.apache.oozie.fluentjob.api.dag.Fork;
import org.apache.oozie.fluentjob.api.dag.Join;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.generated.workflow.ACTION;
import org.apache.oozie.fluentjob.api.generated.workflow.ACTIONTRANSITION;
import org.apache.oozie.fluentjob.api.generated.workflow.CREDENTIALS;
import org.apache.oozie.fluentjob.api.generated.workflow.DECISION;
import org.apache.oozie.fluentjob.api.generated.workflow.END;
import org.apache.oozie.fluentjob.api.generated.workflow.FORK;
import org.apache.oozie.fluentjob.api.generated.workflow.GLOBAL;
import org.apache.oozie.fluentjob.api.generated.workflow.JOIN;
import org.apache.oozie.fluentjob.api.generated.workflow.KILL;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;
import org.apache.oozie.fluentjob.api.generated.workflow.PARAMETERS;
import org.apache.oozie.fluentjob.api.generated.workflow.START;
import org.apache.oozie.fluentjob.api.generated.workflow.WORKFLOWAPP;
import org.apache.oozie.fluentjob.api.mapping.GraphNodes;
import org.apache.oozie.fluentjob.api.workflow.Credentials;
import org.apache.oozie.fluentjob.api.workflow.Global;
import org.apache.oozie.fluentjob.api.workflow.Parameters;

public class GraphNodesToWORKFLOWAPPConverter
extends DozerConverter<GraphNodes, WORKFLOWAPP>
implements MapperAware {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private Mapper mapper;
    private static final Map<Class<? extends Object>, Class<? extends Object>> SOURCE_TARGET_CLASSES = new HashMap<Class<? extends Object>, Class<? extends Object>>();

    public GraphNodesToWORKFLOWAPPConverter() {
        super(GraphNodes.class, WORKFLOWAPP.class);
    }

    public WORKFLOWAPP convertTo(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        workflowapp = this.ensureWorkflowApp(workflowapp);
        workflowapp.setName(graphNodes.getName());
        this.mapParameters(graphNodes, workflowapp);
        this.mapGlobal(graphNodes, workflowapp);
        this.mapCredentials(graphNodes, workflowapp);
        this.mapStart(graphNodes, workflowapp);
        this.mapEnd(graphNodes, workflowapp);
        KILL kill = this.mapKill(workflowapp);
        this.mapChildren(graphNodes, workflowapp, kill);
        return workflowapp;
    }

    private WORKFLOWAPP ensureWorkflowApp(WORKFLOWAPP workflowapp) {
        if (workflowapp == null) {
            workflowapp = new ObjectFactory().createWORKFLOWAPP();
        }
        return workflowapp;
    }

    private void mapParameters(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        if (graphNodes.getParameters() == null) {
            return;
        }
        PARAMETERS mappedParameters = (PARAMETERS)this.mapper.map((Object)graphNodes.getParameters(), PARAMETERS.class);
        workflowapp.setParameters(mappedParameters);
    }

    private void mapGlobal(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        if (graphNodes.getGlobal() == null) {
            return;
        }
        GLOBAL mappedGlobal = (GLOBAL)this.mapper.map((Object)graphNodes.getGlobal(), GLOBAL.class);
        workflowapp.setGlobal(mappedGlobal);
    }

    private void mapCredentials(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        if (graphNodes.getCredentials() == null) {
            return;
        }
        CREDENTIALS mappedCredentials = (CREDENTIALS)this.mapper.map((Object)graphNodes.getCredentials(), CREDENTIALS.class);
        workflowapp.setCredentials(mappedCredentials);
    }

    private void mapStart(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        START start = (START)this.mapper.map((Object)graphNodes.getStart(), START.class);
        workflowapp.setStart(start);
    }

    private void mapEnd(GraphNodes graphNodes, WORKFLOWAPP workflowapp) {
        END end = (END)this.mapper.map((Object)graphNodes.getEnd(), END.class);
        workflowapp.setEnd(end);
    }

    private KILL mapKill(WORKFLOWAPP workflowapp) {
        KILL kill = this.createKillNode();
        workflowapp.getDecisionOrForkOrJoin().add(kill);
        return kill;
    }

    private void mapChildren(GraphNodes graphNodes, WORKFLOWAPP workflowapp, KILL kill) {
        for (NodeBase nodeBase : graphNodes.getNodes()) {
            this.convertNode(nodeBase, workflowapp, kill);
        }
    }

    public GraphNodes convertFrom(WORKFLOWAPP workflowapp, GraphNodes graphNodes) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private void convertNode(NodeBase nodeBase, WORKFLOWAPP workflowapp, KILL kill) {
        Objects.requireNonNull(nodeBase, "nodeBase cannot be null");
        Class<?> sourceClass = nodeBase.getClass();
        if (SOURCE_TARGET_CLASSES.containsKey(sourceClass)) {
            ACTION errorHandlerAction;
            Object mappedObject = this.mapper.map((Object)nodeBase, SOURCE_TARGET_CLASSES.get(sourceClass));
            if (nodeBase instanceof ExplicitNode && (errorHandlerAction = this.ensureErrorTransition(workflowapp, (ExplicitNode)nodeBase, (ACTION)mappedObject, kill)) != null && !workflowapp.getDecisionOrForkOrJoin().contains(errorHandlerAction)) {
                workflowapp.getDecisionOrForkOrJoin().add(errorHandlerAction);
            }
            workflowapp.getDecisionOrForkOrJoin().add(mappedObject);
        }
    }

    private KILL createKillNode() {
        KILL kill = OBJECT_FACTORY.createKILL();
        kill.setName("kill");
        kill.setMessage("Action failed, error message[${wf:errorMessage(wf:lastErrorNode())}]");
        return kill;
    }

    private ACTION ensureErrorTransition(WORKFLOWAPP workflowapp, ExplicitNode node, ACTION action, KILL kill) {
        ACTIONTRANSITION error = this.ensureError(action);
        ErrorHandler errorHandler = node.getRealNode().getErrorHandler();
        if (errorHandler == null) {
            error.setTo(kill.getName());
            return null;
        }
        Node handlerNode = errorHandler.getHandlerNode();
        ACTION handlerAction = this.ensureErrorHandlerAction(workflowapp, handlerNode, kill);
        error.setTo(handlerAction.getName());
        return handlerAction;
    }

    private ACTION ensureErrorHandlerAction(WORKFLOWAPP workflowapp, Node handlerNode, KILL kill) {
        ACTION handlerAction = null;
        for (Object alreadyPresentObject : workflowapp.getDecisionOrForkOrJoin()) {
            ACTION alreadyPresentAction;
            if (!(alreadyPresentObject instanceof ACTION) || !(alreadyPresentAction = (ACTION)alreadyPresentObject).getName().equals(handlerNode.getName())) continue;
            handlerAction = alreadyPresentAction;
            break;
        }
        if (handlerAction == null) {
            handlerAction = this.createErrorHandlerAction(handlerNode, kill);
        }
        return handlerAction;
    }

    private ACTIONTRANSITION ensureError(ACTION action) {
        ACTIONTRANSITION error = action.getError();
        if (error == null) {
            error = OBJECT_FACTORY.createACTIONTRANSITION();
            action.setError(error);
        }
        return error;
    }

    private ACTIONTRANSITION ensureOk(ACTION handlerAction) {
        ACTIONTRANSITION ok = handlerAction.getOk();
        if (ok == null) {
            ok = OBJECT_FACTORY.createACTIONTRANSITION();
            handlerAction.setOk(ok);
        }
        return ok;
    }

    private ACTION createErrorHandlerAction(Node handlerNode, KILL kill) {
        ExplicitNode explicitNode = new ExplicitNode(handlerNode.getName(), handlerNode);
        ACTION handlerAction = (ACTION)this.mapper.map((Object)explicitNode, ACTION.class);
        ACTIONTRANSITION ok = this.ensureOk(handlerAction);
        ok.setTo(kill.getName());
        ACTIONTRANSITION error = this.ensureError(handlerAction);
        error.setTo(kill.getName());
        return handlerAction;
    }

    static {
        SOURCE_TARGET_CLASSES.put(Decision.class, DECISION.class);
        SOURCE_TARGET_CLASSES.put(Fork.class, FORK.class);
        SOURCE_TARGET_CLASSES.put(Join.class, JOIN.class);
        SOURCE_TARGET_CLASSES.put(ExplicitNode.class, ACTION.class);
        SOURCE_TARGET_CLASSES.put(Parameters.class, PARAMETERS.class);
        SOURCE_TARGET_CLASSES.put(Global.class, GLOBAL.class);
        SOURCE_TARGET_CLASSES.put(Credentials.class, CREDENTIALS.class);
    }
}

