/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.hadoop.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopShims {
    FileSystem fs;

    public HadoopShims(FileSystem fs) {
        this.fs = fs;
    }

    public static boolean isSymlinkSupported() {
        return true;
    }

    public Path getSymLinkTarget(Path p) throws IOException {
        try {
            Path tempPath = new URI(p.toString()).getFragment() == null ? p : new Path(new URI(p.toString()).getPath());
            return this.fs.getFileLinkStatus(tempPath).getSymlink();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public boolean isSymlink(Path p) throws IOException {
        try {
            Path tempPath = new URI(p.toString()).getFragment() == null ? p : new Path(new URI(p.toString()).getPath());
            return this.fs.getFileLinkStatus(tempPath).isSymlink();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fs.createSymlink(target, link, createParent);
    }

    public static boolean isYARN() {
        return true;
    }
}

