/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.action.hadoop.OozieActionConfigurator;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;

public abstract class LauncherMain {
    public static final String ACTION_PREFIX = "oozie.action.";
    public static final String EXTERNAL_CHILD_IDS = "oozie.action.externalChildIDs";
    public static final String EXTERNAL_ACTION_STATS = "oozie.action.stats.properties";
    public static final String EXTERNAL_STATS_WRITE = "oozie.action.external.stats.write";
    public static final String OUTPUT_PROPERTIES = "oozie.action.output.properties";
    public static final String HADOOP_JOBS = "hadoopJobs";
    public static final String MAPREDUCE_JOB_TAGS = "mapreduce.job.tags";
    public static final String TEZ_APPLICATION_TAGS = "tez.application.tags";
    public static final String SPARK_YARN_TAGS = "spark.yarn.tags";
    protected static String[] HADOOP_SITE_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml"};

    protected static void run(Class<? extends LauncherMain> klass, String[] args) throws Exception {
        LauncherMain main = klass.newInstance();
        main.run(args);
    }

    protected static String getHadoopJobIds(String logFile, Pattern[] patterns) {
        LinkedHashSet<String> jobIds = new LinkedHashSet<String>();
        if (!new File(logFile).exists()) {
            System.err.println("Log file: " + logFile + "  not present. Therefore no Hadoop job IDs found.");
        } else {
            try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
                String line = br.readLine();
                while (line != null) {
                    for (Pattern pattern : patterns) {
                        String jobId;
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find() || StringUtils.isEmpty((String)(jobId = matcher.group(1))) || jobId.equalsIgnoreCase("NULL")) continue;
                        jobId = jobId.replaceAll("application", "job");
                        jobIds.add(jobId);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                System.out.println("WARN: Error getting Hadoop Job IDs. logFile: " + logFile);
                e.printStackTrace(System.out);
            }
        }
        return jobIds.isEmpty() ? null : StringUtils.join(jobIds, (String)",");
    }

    protected static void writeExternalChildIDs(String logFile, Pattern[] patterns, String name) {
        String jobIds = LauncherMain.getHadoopJobIds(logFile, patterns);
        if (jobIds != null) {
            File externalChildIdsFile = new File(System.getProperty(EXTERNAL_CHILD_IDS));
            try (FileOutputStream externalChildIdsStream = new FileOutputStream(externalChildIdsFile);){
                ((OutputStream)externalChildIdsStream).write(jobIds.getBytes());
                System.out.println("Hadoop Job IDs executed by " + name + ": " + jobIds);
                System.out.println();
            }
            catch (IOException e) {
                System.out.println("WARN: Error while writing to external child ids file: " + System.getProperty(EXTERNAL_CHILD_IDS));
                e.printStackTrace(System.out);
            }
        } else {
            System.out.println("No child hadoop job is executed.");
        }
    }

    protected abstract void run(String[] var1) throws Exception;

    protected static void logMasking(String header, Collection<String> maskSet, Iterable conf) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(header + "\n");
        writer.write("--------------------\n");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            for (String mask : maskSet) {
                if (!name.contains(mask)) continue;
                value = "*MASKED*";
            }
            writer.write(" " + name + " : " + value + "\n");
        }
        writer.write("--------------------\n");
        writer.close();
        System.out.println(writer.toString());
        System.out.flush();
    }

    protected static String getFilePathFromEnv(String env) {
        String path = System.getenv(env);
        if (path != null && Shell.WINDOWS) {
            if (path.charAt(0) == '\"') {
                path = path.substring(1);
            }
            if (path.charAt(path.length() - 1) == '\"') {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    protected static void runConfigClass(JobConf actionConf) throws OozieActionConfiguratorException {
        String configClass = System.getProperty("oozie.action.config.class");
        if (configClass != null) {
            try {
                Class<?> klass = Class.forName(configClass);
                Class<OozieActionConfigurator> actionConfiguratorKlass = klass.asSubclass(OozieActionConfigurator.class);
                OozieActionConfigurator actionConfigurator = actionConfiguratorKlass.newInstance();
                actionConfigurator.configure(actionConf);
            }
            catch (ClassNotFoundException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
            catch (InstantiationException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
            catch (IllegalAccessException e) {
                throw new OozieActionConfiguratorException("An Exception occured while instantiating the action config class", e);
            }
        }
    }

    public static Configuration loadActionConf() throws IOException {
        Configuration actionConf = new Configuration(false);
        String actionXml = System.getProperty("oozie.action.conf.xml");
        if (actionXml == null) {
            throw new RuntimeException("Missing Java System Property [oozie.action.conf.xml]");
        }
        if (!new File(actionXml).exists()) {
            throw new RuntimeException("Action Configuration XML file [" + actionXml + "] does not exist");
        }
        actionConf.addResource(new Path("file:///", actionXml));
        return actionConf;
    }

    protected static void setYarnTag(Configuration actionConf) {
        if (actionConf.get("oozie.child.mapreduce.job.tags") != null) {
            if (actionConf.get(MAPREDUCE_JOB_TAGS) != null) {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get(MAPREDUCE_JOB_TAGS) + "," + actionConf.get("oozie.child.mapreduce.job.tags"));
            } else {
                actionConf.set(MAPREDUCE_JOB_TAGS, actionConf.get("oozie.child.mapreduce.job.tags"));
            }
        }
    }

    protected static void setApplicationTags(Configuration configName, String tagConfigName) {
        if (configName.get(MAPREDUCE_JOB_TAGS) != null) {
            System.out.println("Setting [" + tagConfigName + "] tag: " + configName.get(MAPREDUCE_JOB_TAGS));
            configName.set(tagConfigName, configName.get(MAPREDUCE_JOB_TAGS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFileMultiplex(File src, File ... dst) throws IOException {
        FileInputStream is = null;
        OutputStream[] osa = new OutputStream[dst.length];
        try {
            int read;
            is = new FileInputStream(src);
            for (int i = 0; i < osa.length; ++i) {
                osa[i] = new FileOutputStream(dst[i]);
            }
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)is).read(buffer)) > -1) {
                for (OutputStream os : osa) {
                    os.write(buffer, 0, read);
                }
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            for (OutputStream os : osa) {
                if (os == null) continue;
                os.close();
            }
        }
    }

    protected void writeHadoopConfig(String actionXml, File basrDir) throws IOException {
        File actionXmlFile = new File(actionXml);
        System.out.println("Copying " + actionXml + " to " + basrDir + "/" + Arrays.toString(HADOOP_SITE_FILES));
        basrDir.mkdirs();
        File[] dstFiles = new File[HADOOP_SITE_FILES.length];
        for (int i = 0; i < dstFiles.length; ++i) {
            dstFiles[i] = new File(basrDir, HADOOP_SITE_FILES[i]);
        }
        LauncherMain.copyFileMultiplex(actionXmlFile, dstFiles);
    }
}

