/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

public final class ECPolicyDisabler {
    private static final String GETREPLICATIONPOLICY_METHOD = "getReplicationPolicy";
    private static final String ERASURECODING_POLICIES_CLASS = "org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies";
    private static final String GETNAME_METHOD = "getName";
    private static final String SETERASURECODINGPOLICY_METHOD = "setErasureCodingPolicy";
    private static final String GETERASURECODINGPOLICY_METHOD = "getErasureCodingPolicy";

    public static void tryDisableECPolicyForPath(FileSystem fs, Path path) {
        switch (ECPolicyDisabler.check(fs, path)) {
            case DONE: {
                System.out.println("Done");
                break;
            }
            case ALREADY_SET: {
                System.out.println("Current policy is already replication");
                break;
            }
            case NOT_SUPPORTED: {
                System.out.println("Found Hadoop that does not support Erasure Coding. Not taking any action.");
                break;
            }
            case NO_SUCH_METHOD: {
                System.out.println("HDFS Namenode doesn't support Erasure Coding.");
            }
        }
    }

    static Result check(FileSystem fs, Path path) {
        if (fs instanceof DistributedFileSystem && ECPolicyDisabler.supportsErasureCoding()) {
            System.out.println("Found Hadoop that supports Erasure Coding. Trying to disable Erasure Coding for path: " + path);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            Object replicationPolicy = ECPolicyDisabler.getReplicationPolicy();
            Method getErasureCodingPolicyMethod = ECPolicyDisabler.getMethod(dfs, GETERASURECODINGPOLICY_METHOD);
            Pair currentECPolicy = ECPolicyDisabler.safeInvokeMethod(getErasureCodingPolicyMethod, dfs, path);
            if (currentECPolicy.getRight() != null) {
                return (Result)((Object)currentECPolicy.getRight());
            }
            if (currentECPolicy.getLeft() != replicationPolicy) {
                Method setECPolicyMethod = ECPolicyDisabler.getMethod(dfs, SETERASURECODINGPOLICY_METHOD);
                Method policyGetNameMethod = ECPolicyDisabler.getMethod(replicationPolicy, GETNAME_METHOD);
                Pair pairName = ECPolicyDisabler.safeInvokeMethod(policyGetNameMethod, replicationPolicy, new Object[0]);
                if (pairName.getRight() != null) {
                    return (Result)((Object)pairName.getRight());
                }
                Pair result = ECPolicyDisabler.safeInvokeMethod(setECPolicyMethod, dfs, path, pairName.getLeft());
                if (result.getRight() != null) {
                    return (Result)((Object)result.getRight());
                }
                return Result.DONE;
            }
            return Result.ALREADY_SET;
        }
        return Result.NOT_SUPPORTED;
    }

    private static <X> Pair<X, Result> safeInvokeMethod(Method method, Object instance, Object ... args) {
        try {
            return Pair.of((Object)ECPolicyDisabler.invokeMethod(method, instance, args), null);
        }
        catch (RuntimeException e) {
            RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto errorCode = ECPolicyDisabler.unwrapRemote(e);
            if (errorCode == RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_NO_SUCH_METHOD) {
                return Pair.of(null, (Object)((Object)Result.NO_SUCH_METHOD));
            }
            throw e;
        }
    }

    private static RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto unwrapRemote(Throwable e) {
        if (e instanceof InvocationTargetException) {
            return ECPolicyDisabler.unwrapRemote(e.getCause());
        }
        if (e instanceof RuntimeException) {
            return ECPolicyDisabler.unwrapRemote(e.getCause());
        }
        return e instanceof RemoteException ? ((RemoteException)e).getErrorCode() : null;
    }

    private static boolean supportsErasureCoding() {
        try {
            ECPolicyDisabler.getECPoliciesClass();
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object getReplicationPolicy() {
        try {
            Class<?> c = ECPolicyDisabler.getECPoliciesClass();
            Method m = c.getMethod(GETREPLICATIONPOLICY_METHOD, new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Error accessing method with reflection");
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getECPoliciesClass() throws ClassNotFoundException {
        return Class.forName(ERASURECODING_POLICIES_CLASS);
    }

    private static Method getMethod(Object object, String methodName) {
        Method[] methods = object.getClass().getMethods();
        Method method = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method " + methodName + "() not found");
        }
        return method;
    }

    private static Object invokeMethod(Method m, Object instance, Object ... args) {
        try {
            return m.invoke(instance, args);
        }
        catch (RuntimeException e) {
            System.err.println("Error invoking method with reflection");
            return e;
        }
        catch (Exception e) {
            System.err.println("Error invoking method with reflection");
            throw new RuntimeException(e);
        }
    }

    static enum Result {
        DONE,
        NO_SUCH_METHOD,
        ALREADY_SET,
        NOT_SUPPORTED;

    }
}

