/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.tools.diag.DiagBundleEntryWriter;
import org.apache.oozie.tools.diag.DiagOozieClient;
import org.apache.oozie.tools.diag.OozieLauncherLogFetcher;
import org.apache.oozie.util.XConfiguration;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Output directory is specified by user")
class AppInfoCollector {
    private final DiagOozieClient client;
    private final OozieLauncherLogFetcher oozieLauncherLogFetcher;

    AppInfoCollector(Configuration hadoopConfig, DiagOozieClient client) {
        this.client = client;
        this.oozieLauncherLogFetcher = new OozieLauncherLogFetcher(hadoopConfig);
    }

    private void storeWorkflowJobDetails(File outputDir, String jobId, int maxChildActions) {
        if (jobId == null || !this.isWorkflow(jobId)) {
            return;
        }
        try {
            System.out.print("Getting Details for " + jobId + "...");
            File workflowOutputDir = new File(outputDir, jobId);
            if (!this.createOutputDirectory(workflowOutputDir)) {
                return;
            }
            File resolvedActionsDir = new File(workflowOutputDir, "resolved-actions");
            if (!this.createOutputDirectory(resolvedActionsDir)) {
                System.out.println("Workflow details already stored.");
                return;
            }
            WorkflowJob job = this.client.getJobInfo(jobId);
            try (DiagBundleEntryWriter diagBundleEntryWriter = new DiagBundleEntryWriter(workflowOutputDir, "info.txt");){
                this.persistWorkflowJobInfo(maxChildActions, resolvedActionsDir, job, diagBundleEntryWriter);
            }
            this.storeCommonDetails(workflowOutputDir, jobId, "workflow", job.getConf());
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of workflow information: %s%n", e.getMessage());
        }
    }

    private void persistWorkflowJobInfo(int maxChildActions, File resolvedActionsDir, WorkflowJob job, DiagBundleEntryWriter bundleEntryWriter) throws IOException {
        bundleEntryWriter.writeString("WORKFLOW\n").writeString("--------\n").writeStringValue("Workflow Id        : ", job.getId()).writeStringValue("Name               : ", job.getAppName()).writeStringValue("App Path           : ", job.getAppPath()).writeStringValue("User               : ", job.getUser()).writeStringValue("ACL                : ", job.getAcl()).writeStringValue("Status             : ", job.getStatus().toString()).writeStringValue("Console URL        : ", job.getConsoleUrl()).writeStringValue("External Id        : ", job.getExternalId()).writeStringValue("Parent Id          : ", job.getParentId()).writeDateValue("Created Time       : ", job.getCreatedTime()).writeDateValue("End Time           : ", job.getEndTime()).writeDateValue("Last Modified Time : ", job.getLastModifiedTime()).writeDateValue("Start Time         : ", job.getStartTime()).writeIntValue("Run                : ", job.getRun()).writeIntValue("Action Count       : ", job.getActions().size()).writeNewLine().writeString("ACTIONS\n").writeString("------\n").flush();
        List workflowActions = job.getActions();
        for (int actionCount = 0; actionCount != workflowActions.size() && actionCount < maxChildActions; ++actionCount) {
            WorkflowAction action = (WorkflowAction)workflowActions.get(actionCount);
            bundleEntryWriter.writeStringValue("Action Id          : ", action.getId()).writeStringValue("Name               : ", action.getName()).writeStringValue("Type               : ", action.getType()).writeStringValue("Status             : ", action.getStatus().toString()).writeStringValue("Transition         : ", action.getTransition()).writeDateValue("Start Time         : ", action.getStartTime()).writeDateValue("End Time           : ", action.getEndTime()).writeStringValue("Error Code         : ", action.getErrorCode()).writeStringValue("Error Message      : ", action.getErrorMessage()).writeStringValue("Console URL        : ", action.getConsoleUrl()).writeStringValue("Tracker URI        : ", action.getTrackerUri()).writeStringValue("External Child Ids : ", action.getExternalChildIDs()).writeStringValue("External Id        : ", action.getExternalId()).writeStringValue("External Status    : ", action.getExternalStatus()).writeStringValue("Data               : ", action.getData()).writeStringValue("Stats              : ", action.getStats()).writeStringValue("Credentials        : ", action.getCred()).writeIntValue("Retries            : ", action.getRetries()).writeIntValue("User Retry Int     : ", action.getUserRetryInterval()).writeIntValue("User Retry Count   : ", action.getUserRetryCount()).writeIntValue("User Retry Max     : ", action.getUserRetryMax()).writeNewLine().flush();
            String actionType = action.getType();
            this.persistResolvedActionDefinition(action, resolvedActionsDir);
            if (this.isControlNode(actionType)) continue;
            this.storeOozieLauncherLog(resolvedActionsDir, action, job.getUser());
        }
    }

    private boolean isControlNode(String actionType) {
        return this.isNonDecisionControlNode(actionType) || this.isDecisionNode(actionType);
    }

    private boolean isDecisionNode(String actionType) {
        return actionType.contains("switch");
    }

    private boolean isNonDecisionControlNode(String actionType) {
        return actionType.contains(":");
    }

    private void persistResolvedActionDefinition(WorkflowAction action, File resolvedActionsDir) throws IOException {
        this.persistWorkflowDefinition(resolvedActionsDir, action.getName(), action.getConf());
    }

    private void storeOozieLauncherLog(File outputDir, WorkflowAction action, String user) {
        try (PrintStream fw = new PrintStream(new File(outputDir, "launcher_" + action.getName() + ".log"), StandardCharsets.UTF_8.name());){
            ApplicationId appId = ConverterUtils.toApplicationId((String)action.getExternalId());
            this.oozieLauncherLogFetcher.dumpAllContainersLogs(appId, user, fw);
        }
        catch (IOException e) {
            System.err.printf("Exception occurred during the retrieval of Oozie launcher logs for workflow(s): %s%n", e.getMessage());
        }
    }

    private void getCoordJob(File outputDir, String jobId, int maxChildActions) {
        if (jobId == null || !this.isCoordinator(jobId)) {
            return;
        }
        try {
            System.out.print("Getting Details for " + jobId + "...");
            File coordOutputDir = new File(outputDir, jobId);
            if (!this.createOutputDirectory(coordOutputDir)) {
                return;
            }
            CoordinatorJob job = this.client.getCoordJobInfo(jobId);
            try (DiagBundleEntryWriter bundleEntryWriter = new DiagBundleEntryWriter(coordOutputDir, "info.txt");){
                this.persistCoordinatorJobInfo(maxChildActions, job, bundleEntryWriter);
            }
            this.storeCommonDetails(coordOutputDir, jobId, "coordinator", job.getConf());
            System.out.println("Done");
            List coordinatorActions = job.getActions();
            for (int i = 0; i != coordinatorActions.size() && i < maxChildActions; ++i) {
                this.storeWorkflowJobDetails(outputDir, ((CoordinatorAction)coordinatorActions.get(i)).getExternalId(), maxChildActions);
            }
        }
        catch (IOException | OozieClientException e) {
            System.err.printf(String.format("Exception occurred during the retrieval of coordinator information:%s%n", e.getMessage()), new Object[0]);
        }
    }

    private void persistCoordinatorJobInfo(int maxChildActions, CoordinatorJob job, DiagBundleEntryWriter bundleEntryWriter) throws IOException {
        bundleEntryWriter.writeString("COORDINATOR\n").writeString("-----------\n").writeStringValue("Coordinator Id           : ", job.getId()).writeStringValue("Name                     : ", job.getAppName()).writeStringValue("App Path                 : ", job.getAppPath()).writeStringValue("User                     : ", job.getUser()).writeStringValue("ACL                      : ", job.getAcl()).writeStringValue("Status                   : ", job.getStatus().toString()).writeStringValue("Console URL              : ", job.getConsoleUrl()).writeStringValue("External Id              : ", job.getExternalId()).writeStringValue("Bundle Id                : ", job.getBundleId()).writeStringValue("Frequency                : ", job.getFrequency()).writeStringValue("Time Unit                : ", job.getTimeUnit().toString()).writeDateValue("Start Time               : ", job.getStartTime()).writeDateValue("End Time                 : ", job.getEndTime()).writeDateValue("Last Action Time         : ", job.getLastActionTime()).writeDateValue("Next Materialized Time   : ", job.getNextMaterializedTime()).writeDateValue("Pause Time               : ", job.getPauseTime()).writeStringValue("Timezone                 : ", job.getTimeZone()).writeIntValue("Concurrency              : ", job.getConcurrency()).writeIntValue("Timeout                  : ", job.getTimeout()).writeStringValue("Execution Order          : ", job.getExecutionOrder().toString()).writeIntValue("Action Count             : ", job.getActions().size()).writeNewLine().writeString("ACTIONS\n").writeString("------\n").flush();
        List coordinatorActions = job.getActions();
        for (int i = 0; i < maxChildActions && i != coordinatorActions.size(); ++i) {
            CoordinatorAction action = (CoordinatorAction)coordinatorActions.get(i);
            bundleEntryWriter.writeStringValue("Action Id                 : ", action.getId()).writeIntValue("Action Number             : ", action.getActionNumber()).writeStringValue("Job Id                    : ", action.getJobId()).writeStringValue("Status                    : ", action.getStatus().toString()).writeStringValue("External Id               : ", action.getExternalId()).writeStringValue("External Status           : ", action.getExternalStatus()).writeStringValue("Console URL               : ", action.getConsoleUrl()).writeStringValue("Tracker URI               : ", action.getTrackerUri()).writeDateValue("Created Time              : ", action.getCreatedTime()).writeDateValue("Nominal Time              : ", action.getNominalTime()).writeDateValue("Last Modified Time        : ", action.getLastModifiedTime()).writeStringValue("Error Code                : ", action.getErrorCode()).writeStringValue("Error Message             : ", action.getErrorMessage()).writeStringValue("Missing Dependencies      : ", action.getMissingDependencies()).writeStringValue("Push Missing Dependencies : ", action.getPushMissingDependencies()).writeNewLine().flush();
        }
    }

    private void getBundleJob(File outputDir, String jobId, int maxChildActions) {
        if (jobId == null || !this.isBundle(jobId)) {
            return;
        }
        try {
            System.out.print("Getting Details for " + jobId + "...");
            File bundleOutputDir = new File(outputDir, jobId);
            if (!this.createOutputDirectory(bundleOutputDir)) {
                return;
            }
            BundleJob job = this.client.getBundleJobInfo(jobId);
            try (DiagBundleEntryWriter bundleEntryWriter = new DiagBundleEntryWriter(bundleOutputDir, "info.txt");){
                this.persistBundleJobInfo(job, bundleEntryWriter);
            }
            this.storeCommonDetails(bundleOutputDir, jobId, "bundle", job.getConf());
            System.out.println("Done");
            for (CoordinatorJob coordJob : job.getCoordinators()) {
                this.getCoordJob(outputDir, coordJob.getId(), maxChildActions);
            }
        }
        catch (IOException | OozieClientException e) {
            System.err.printf(String.format("Exception occurred during the retrieval of bundle information: %s%n", e.getMessage()), new Object[0]);
        }
    }

    private boolean createOutputDirectory(File outputDir) throws IOException {
        if (outputDir.isDirectory()) {
            System.out.println("(Already) Done");
            return false;
        }
        if (!outputDir.mkdirs()) {
            throw new IOException("Could not create output directory: " + outputDir.getAbsolutePath());
        }
        return true;
    }

    private void persistBundleJobInfo(BundleJob job, DiagBundleEntryWriter bundleEntryWriter) throws IOException {
        bundleEntryWriter.writeString("BUNDLE\n").writeString("-----------\n").writeStringValue("Bundle Id    : ", job.getId()).writeStringValue("Name         : ", job.getAppName()).writeStringValue("App Path     : ", job.getAppPath()).writeStringValue("User         : ", job.getUser()).writeStringValue("Status       : ", job.getStatus().toString()).writeDateValue("Created Time : ", job.getCreatedTime()).writeDateValue("Start Time   : ", job.getStartTime()).writeDateValue("End Time     : ", job.getEndTime()).writeDateValue("KickoffTime  : ", job.getKickoffTime()).writeDateValue("Pause Time   : ", job.getPauseTime()).writeIntValue("Timeout      : ", job.getTimeout()).writeStringValue("Console URL  : ", job.getConsoleUrl()).writeStringValue("ACL          : ", job.getAcl()).flush();
    }

    private void storeCommonDetails(File outputDir, String jobId, String definitionName, String jobPropsConfStr) {
        try {
            String definition = this.client.getJobDefinition(jobId);
            if (definition != null) {
                this.persistWorkflowDefinition(outputDir, definitionName, definition);
            }
            if (jobPropsConfStr != null) {
                this.persistJobProperties(outputDir, jobPropsConfStr);
            }
            this.persistJobLog(outputDir, jobId);
        }
        catch (IOException | OozieClientException e) {
            System.err.printf(String.format("Exception occurred during the retrieval of common job details: %s%n", e.getMessage()), new Object[0]);
        }
    }

    private void persistJobLog(File outputDir, String jobId) throws FileNotFoundException, UnsupportedEncodingException, OozieClientException {
        try (PrintStream ps = new PrintStream(new File(outputDir, "log.txt"), StandardCharsets.UTF_8.name());){
            this.client.getJobLog(jobId, null, null, null, ps);
        }
    }

    private void persistJobProperties(File outputDir, String jobPropsConfStr) throws IOException {
        StringReader sr = new StringReader(jobPropsConfStr);
        XConfiguration jobPropsConf = new XConfiguration((Reader)sr);
        Properties jobProps = jobPropsConf.toProperties();
        try (FileOutputStream outputStream = new FileOutputStream(new File(outputDir, "job.properties"));){
            jobProps.store(outputStream, "");
        }
    }

    private void persistWorkflowDefinition(File outputDir, String definitionName, String definition) throws IOException {
        try (DiagBundleEntryWriter bundleEntryWriter = new DiagBundleEntryWriter(outputDir, definitionName + ".xml");){
            bundleEntryWriter.writeString(definition);
        }
    }

    void storeLastWorkflows(File outputDir, int numWorkflows, int maxChildActions) {
        if (numWorkflows == 0) {
            return;
        }
        try {
            List jobs = this.client.getJobsInfo(null, 0, numWorkflows);
            for (WorkflowJob job : jobs) {
                this.storeWorkflowJobDetails(outputDir, job.getId(), maxChildActions);
            }
        }
        catch (OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of information on the last %d workflow(s): %s.%n", numWorkflows, e.getMessage());
        }
    }

    void storeLastCoordinators(File outputDir, int numCoordinators, int maxChildActions) {
        if (numCoordinators == 0) {
            return;
        }
        try {
            List jobs = this.client.getCoordJobsInfo(null, 0, numCoordinators);
            for (CoordinatorJob job : jobs) {
                this.getCoordJob(outputDir, job.getId(), maxChildActions);
            }
        }
        catch (OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of information on the last %d coordinator(s): %s.%n", numCoordinators, e.getMessage());
        }
    }

    void storeLastBundles(File outputDir, int numBundles, int maxChildActions) {
        if (numBundles == 0) {
            return;
        }
        try {
            List jobs = this.client.getBundleJobsInfo(null, 0, numBundles);
            for (BundleJob job : jobs) {
                this.getBundleJob(outputDir, job.getId(), maxChildActions);
            }
        }
        catch (OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of information on the last %d bundle(s): %s.%n", numBundles, e.getMessage());
        }
    }

    void getSpecificJobs(File outputDir, String[] jobIds, int maxChildActions) {
        if (jobIds == null) {
            return;
        }
        for (String jobId : jobIds) {
            if (this.isWorkflow(jobId)) {
                this.storeWorkflowJobDetails(outputDir, jobId, maxChildActions);
                continue;
            }
            if (this.isCoordinator(jobId)) {
                this.getCoordJob(outputDir, jobId, maxChildActions);
                continue;
            }
            if (!this.isBundle(jobId)) continue;
            this.getBundleJob(outputDir, jobId, maxChildActions);
        }
    }

    private boolean isBundle(String jobId) {
        return jobId.endsWith("-B");
    }

    private boolean isCoordinator(String jobId) {
        return jobId.endsWith("-C");
    }

    private boolean isWorkflow(String jobId) {
        return jobId.endsWith("-W");
    }
}

