/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Output directory is specified by user")
class ArgParser {
    private static final String OOZIE_OPTION = "oozie";
    private static final String NUM_WORKFLOWS_OPTION = "numworkflows";
    private static final String NUM_COORDS_OPTION = "numcoordinators";
    private static final String NUM_BUNDLES_OPTION = "numbundles";
    private static final String JOBS_OPTION = "jobs";
    private static final String MAX_CHILD_ACTIONS = "maxchildactions";
    private static final String OUTPUT_DIR_OPTION = "output";
    private final Options options = new Options();
    private CommandLine commandLine;

    ArgParser() {
    }

    public void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    private void addNewOption(String optionName, String argName, String details, boolean required) {
        this.addNewOption(optionName, argName, details, null, required, null, false);
    }

    private void addNewOption(String optionName, String argName, String details, Class type, boolean required) {
        this.addNewOption(optionName, argName, details, type, required, null, false);
    }

    private void addNewOption(String optionName, String argName, String details, Class type, boolean required, Character valueSeparator, boolean isUnlimited) {
        Option option = new Option(optionName, true, details);
        option.setRequired(required);
        option.setArgName(argName);
        if (type != null) {
            option.setType((Object)type);
        }
        if (valueSeparator != null) {
            option.setValueSeparator(valueSeparator.charValue());
        }
        if (isUnlimited) {
            option.setArgs(-2);
        }
        this.options.addOption(option);
    }

    Options setupOptions() {
        this.addNewOption(OOZIE_OPTION, "url", String.format("Required: Oozie URL (or specify with %s env var)", "OOZIE_URL"), true);
        this.addNewOption(NUM_WORKFLOWS_OPTION, "n", "Detailed information on the last n workflows will be collected (default: 0)", Integer.class, false);
        this.addNewOption(NUM_COORDS_OPTION, "n", "Detailed information on the last n Coordinators will be collected (default: 0)", Integer.class, false);
        this.addNewOption(NUM_BUNDLES_OPTION, "n", "Detailed information on the last n Bundles will be collected (default: 0)", Integer.class, false);
        this.addNewOption(JOBS_OPTION, "id ...", "Detailed information on the given job IDs will be collected (default: none)", null, false, Character.valueOf(','), true);
        this.addNewOption(MAX_CHILD_ACTIONS, "n", "Maximum number of Workflow or Coordinator actions that will be collected (default: 10)", Integer.class, false);
        this.addNewOption(OUTPUT_DIR_OPTION, "dir", "Required: Directory to output the zip file", true);
        return this.options;
    }

    File ensureOutputDir() throws IOException {
        String output = this.commandLine.getOptionValue(OUTPUT_DIR_OPTION);
        Objects.requireNonNull(output, "output cannot be null");
        File outputDir = new File(output);
        if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new IOException("Could not create output directory: " + outputDir.getAbsolutePath());
        }
        return outputDir;
    }

    Integer getMaxChildActions() {
        Integer maxChildActions = Integer.valueOf(this.commandLine.getOptionValue(MAX_CHILD_ACTIONS, "10"));
        Preconditions.checkArgument((maxChildActions >= 0 ? 1 : 0) != 0, (Object)"maxchildactions cannot be negative");
        return maxChildActions;
    }

    String[] getJobIds() {
        return this.commandLine.getOptionValues(JOBS_OPTION);
    }

    Integer getNumBundles() {
        Integer numBundles = Integer.valueOf(this.commandLine.getOptionValue(NUM_BUNDLES_OPTION, "0"));
        Preconditions.checkArgument((numBundles >= 0 ? 1 : 0) != 0, (Object)"numbundles cannot be negative");
        return numBundles;
    }

    Integer getNumCoordinators() {
        Integer numCoords = Integer.valueOf(this.commandLine.getOptionValue(NUM_COORDS_OPTION, "0"));
        Preconditions.checkArgument((numCoords >= 0 ? 1 : 0) != 0, (Object)"numcoordinators cannot be negative");
        return numCoords;
    }

    Integer getNumWorkflows() {
        Integer numWorkflows = Integer.valueOf(this.commandLine.getOptionValue(NUM_WORKFLOWS_OPTION, "0"));
        Preconditions.checkArgument((numWorkflows >= 0 ? 1 : 0) != 0, (Object)"numworkflows cannot be negative");
        return numWorkflows;
    }

    String getOozieUrl() {
        String url = this.commandLine.getOptionValue(OOZIE_OPTION);
        if (url == null && (url = System.getenv("OOZIE_URL")) == null) {
            throw new IllegalArgumentException("Oozie URL is not available neither in command option or in the environment");
        }
        return url;
    }

    boolean parseCommandLineArguments(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = this.setupOptions();
        try {
            this.commandLine = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.print("Error: " + pe.getMessage());
            System.err.println();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("DiagBundleCollectorDriver", "A tool that collects a diagnostic bundle of information from Oozie", options, "", true);
            return false;
        }
        return true;
    }
}

