/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;

public class OozieLauncherLogFetcher {
    private static final String TMP_FILE_SUFFIX = ".tmp";
    private final Configuration hadoopConfig;

    public OozieLauncherLogFetcher(Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
    }

    private static void logDirNotExist(String remoteAppLogDir) {
        System.out.println(remoteAppLogDir + "does not exist.");
        System.out.println("Log aggregation has not completed or is not enabled.");
    }

    private static void emptyLogDir(String remoteAppLogDir) {
        System.out.println(remoteAppLogDir + "does not have any log files.");
    }

    public static String getRemoteNodeLogDirSuffix(Configuration conf) {
        return conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
    }

    public static Path getRemoteLogSuffixedDir(Path remoteRootLogDir, String user, String suffix) {
        return suffix != null && !suffix.isEmpty() ? new Path(OozieLauncherLogFetcher.getRemoteLogUserDir(remoteRootLogDir, user), suffix) : OozieLauncherLogFetcher.getRemoteLogUserDir(remoteRootLogDir, user);
    }

    public static Path getRemoteLogUserDir(Path remoteRootLogDir, String user) {
        return new Path(remoteRootLogDir, user);
    }

    public static Path getRemoteAppLogDir(Path remoteRootLogDir, ApplicationId appId, String user, String suffix) {
        return new Path(OozieLauncherLogFetcher.getRemoteLogSuffixedDir(remoteRootLogDir, user, suffix), appId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dumpAllContainersLogs(ApplicationId appId, String appOwner, PrintStream out) throws IOException {
        RemoteIterator nodeFiles;
        Path remoteRootLogDir = new Path(this.hadoopConfig.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String logDirSuffix = OozieLauncherLogFetcher.getRemoteNodeLogDirSuffix(this.hadoopConfig);
        Path remoteAppLogDir = OozieLauncherLogFetcher.getRemoteAppLogDir(remoteRootLogDir, appId, appOwner, logDirSuffix);
        try {
            Path qualifiedLogDir = FileContext.getFileContext((Configuration)this.hadoopConfig).makeQualified(remoteAppLogDir);
            nodeFiles = FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)this.hadoopConfig).listStatus(remoteAppLogDir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            OozieLauncherLogFetcher.logDirNotExist(remoteAppLogDir.toString());
            return -1;
        }
        boolean foundAnyLogs = false;
        block7: while (true) {
            if (!nodeFiles.hasNext()) {
                if (!foundAnyLogs) {
                    OozieLauncherLogFetcher.emptyLogDir(remoteAppLogDir.toString());
                    return -1;
                }
                return 0;
            }
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            if (thisNodeFile.getPath().getName().endsWith(TMP_FILE_SUFFIX)) continue;
            AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.hadoopConfig, thisNodeFile.getPath());
            try {
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (true) {
                    if (valueStream == null) continue block7;
                    String containerString = "\n\nContainer: " + key + " on " + thisNodeFile.getPath().getName();
                    out.println(containerString);
                    out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
                    try {
                        while (true) {
                            AggregatedLogFormat.LogReader.readAContainerLogsForALogType((DataInputStream)valueStream, (PrintStream)out, (long)thisNodeFile.getModificationTime());
                            foundAnyLogs = true;
                        }
                    }
                    catch (EOFException eofException) {
                        key = new AggregatedLogFormat.LogKey();
                        valueStream = reader.next(key);
                        continue;
                    }
                    break;
                }
            }
            finally {
                reader.close();
                continue;
            }
            break;
        }
    }
}

