/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools.diag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.tools.diag.DiagBundleEntryWriter;
import org.apache.oozie.tools.diag.DiagOozieClient;

class ServerInfoCollector {
    private final DiagOozieClient client;

    ServerInfoCollector(DiagOozieClient client) {
        this.client = client;
    }

    void storeShareLibInfo(File outputDir) {
        try {
            System.out.print("Getting Sharelib Information...");
            String[] libs = this.client.listShareLib(null).split("\n");
            try (DiagBundleEntryWriter configEntryWriter = new DiagBundleEntryWriter(outputDir, "sharelib.txt");){
                for (int i = 1; i < libs.length; ++i) {
                    String files = this.client.listShareLib(libs[i]);
                    configEntryWriter.writeString(files);
                    configEntryWriter.writeNewLine();
                }
            }
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of ShareLib information: %s%n", e.getMessage());
        }
    }

    void storeJavaSystemProperties(File outputDir) {
        try {
            System.out.print("Getting Java System Properties...");
            Map javaSysProps = this.client.getJavaSystemProperties();
            try (DiagBundleEntryWriter configEntryWriter = new DiagBundleEntryWriter(outputDir, "java-sys-props.txt");){
                for (Map.Entry ent : javaSysProps.entrySet()) {
                    configEntryWriter.writeStringValue((String)ent.getKey() + " : ", (String)ent.getValue());
                }
            }
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of Java system property settings for the Oozie server: %s%n", e.getMessage());
        }
    }

    void storeOsEnv(File outputDir) {
        try {
            System.out.print("Getting OS Environment Variables...");
            Map osEnv = this.client.getOSEnv();
            try (DiagBundleEntryWriter configEntryWriter = new DiagBundleEntryWriter(outputDir, "os-env-vars.txt");){
                for (Map.Entry ent : osEnv.entrySet()) {
                    configEntryWriter.writeStringValue((String)ent.getKey() + " : ", (String)ent.getValue());
                }
            }
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of environment variable settings for the Oozie server:%s%n", e.getMessage());
        }
    }

    void storeServerConfiguration(File outputDir) {
        try {
            System.out.print("Getting Configuration...");
            Map serverConfigMap = this.client.getServerConfiguration();
            Configuration serverConfig = new Configuration(false);
            for (Map.Entry ent : serverConfigMap.entrySet()) {
                serverConfig.set((String)ent.getKey(), (String)ent.getValue());
            }
            try (FileOutputStream outputStream = new FileOutputStream(new File(outputDir, "effective-oozie-site.xml"));){
                serverConfig.writeXml((OutputStream)outputStream);
            }
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of effective Oozie server configuration \"oozie-site.xml\": %s%n", e.getMessage());
        }
    }

    void storeThreadDump(File outputDir) {
        try {
            System.out.print("Getting Thread Dump...");
            this.client.saveThreadDumpPage(new File(outputDir, "thread-dump.html"));
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.printf("Exception occurred during the retrieval of Oozie server thread dump: %s%n", e.getMessage());
        }
    }

    void storeCallableQueueDump(File outputDir) {
        try {
            System.out.print("Getting Queue Dump...");
            List queueDump = this.client.getQueueDump();
            try (DiagBundleEntryWriter configEntryWriter = new DiagBundleEntryWriter(outputDir, "queue-dump.txt");){
                for (String d : queueDump) {
                    configEntryWriter.writeString(d);
                    configEntryWriter.writeNewLine();
                }
            }
            System.out.println("Done");
        }
        catch (IOException | OozieClientException e) {
            System.err.println("Exception occurred during the retrieval of Oozie queue dump: " + e.getMessage());
        }
    }
}

