/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.opendal.Environment;

public abstract class NativeObject
implements AutoCloseable {
    private static final AtomicReference<LibraryState> libraryLoaded = new AtomicReference<LibraryState>(LibraryState.NOT_LOADED);
    protected final long nativeHandle;

    public static void loadLibrary() {
        if (libraryLoaded.get() == LibraryState.LOADED) {
            return;
        }
        if (libraryLoaded.compareAndSet(LibraryState.NOT_LOADED, LibraryState.LOADING)) {
            try {
                NativeObject.doLoadLibrary();
            }
            catch (IOException e) {
                libraryLoaded.set(LibraryState.NOT_LOADED);
                throw new UncheckedIOException("Unable to load the OpenDAL shared library", e);
            }
            libraryLoaded.set(LibraryState.LOADED);
            return;
        }
        while (libraryLoaded.get() == LibraryState.LOADING) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static void doLoadLibrary() throws IOException {
        try {
            System.loadLibrary("opendal_java");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeObject.doLoadBundledLibrary();
            return;
        }
    }

    private static void doLoadBundledLibrary() throws IOException {
        String libraryPath = NativeObject.bundledLibraryPath();
        try (InputStream is = NativeObject.class.getResourceAsStream(libraryPath);){
            if (is == null) {
                throw new IOException("cannot find " + libraryPath);
            }
            int dot = libraryPath.indexOf(46);
            File tmpFile = File.createTempFile(libraryPath.substring(0, dot), libraryPath.substring(dot));
            tmpFile.deleteOnExit();
            Files.copy(is, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.load(tmpFile.getAbsolutePath());
        }
    }

    private static String bundledLibraryPath() {
        String os = System.getProperty("os.name").toLowerCase();
        StringBuilder path = new StringBuilder("/native/" + Environment.getClassifier() + "/");
        if (!os.startsWith("windows")) {
            path.append("lib");
        }
        path.append("opendal_java");
        if (os.startsWith("windows")) {
            path.append(".dll");
        } else if (os.startsWith("mac")) {
            path.append(".dylib");
        } else {
            path.append(".so");
        }
        return path.toString();
    }

    protected NativeObject(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    @Override
    public void close() {
        this.disposeInternal(this.nativeHandle);
    }

    protected abstract void disposeInternal(long var1);

    static {
        NativeObject.loadLibrary();
    }

    private static enum LibraryState {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

