/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.opendal.Metadata;
import org.apache.opendal.NativeObject;

public class Operator
extends NativeObject {
    public Operator(String schema, Map<String, String> map) {
        super(Operator.constructor(schema, map));
    }

    public CompletableFuture<Void> write(String path, String content) {
        return this.write(path, content.getBytes(StandardCharsets.UTF_8));
    }

    public CompletableFuture<Void> write(String path, byte[] content) {
        long requestId = Operator.write(this.nativeHandle, path, content);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> append(String path, String content) {
        return this.append(path, content.getBytes(StandardCharsets.UTF_8));
    }

    public CompletableFuture<Void> append(String path, byte[] content) {
        long requestId = Operator.append(this.nativeHandle, path, content);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Metadata> stat(String path) {
        long requestId = Operator.stat(this.nativeHandle, path);
        CompletableFuture f = AsyncRegistry.take(requestId);
        return f.thenApply(Metadata::new);
    }

    public CompletableFuture<String> read(String path) {
        long requestId = Operator.read(this.nativeHandle, path);
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> presignRead(String path, Duration duration) {
        long requestId = Operator.presignRead(this.nativeHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> presignWrite(String path, Duration duration) {
        long requestId = Operator.presignWrite(this.nativeHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> presignStat(String path, Duration duration) {
        long requestId = Operator.presignStat(this.nativeHandle, path, duration.toNanos());
        return AsyncRegistry.take(requestId);
    }

    public CompletableFuture<Void> delete(String path) {
        long requestId = Operator.delete(this.nativeHandle, path);
        return AsyncRegistry.take(requestId);
    }

    @Override
    protected native void disposeInternal(long var1);

    private static native long constructor(String var0, Map<String, String> var1);

    private static native long read(long var0, String var2);

    private static native long write(long var0, String var2, byte[] var3);

    private static native long append(long var0, String var2, byte[] var3);

    private static native long delete(long var0, String var2);

    private static native long stat(long var0, String var2);

    private static native long presignRead(long var0, String var2, long var3);

    private static native long presignWrite(long var0, String var2, long var3);

    private static native long presignStat(long var0, String var2, long var3);

    private static enum AsyncRegistry {
        INSTANCE;

        private final Map<Long, CompletableFuture<?>> registry = new ConcurrentHashMap();

        private static long requestId() {
            long requestId;
            CompletableFuture prev;
            CompletableFuture f = new CompletableFuture();
            while ((prev = AsyncRegistry.INSTANCE.registry.putIfAbsent(requestId = Math.abs(UUID.randomUUID().getLeastSignificantBits()), f)) != null) {
            }
            return requestId;
        }

        private static CompletableFuture<?> get(long requestId) {
            return AsyncRegistry.INSTANCE.registry.get(requestId);
        }

        private static <T> CompletableFuture<T> take(long requestId) {
            CompletableFuture<?> f = AsyncRegistry.get(requestId);
            if (f != null) {
                f.whenComplete((r, e) -> AsyncRegistry.INSTANCE.registry.remove(requestId));
            }
            return f;
        }
    }
}

